/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi;

import dev.galasa.framework.internal.rps.ResourceString;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicResource;
import dev.galasa.framework.spi.IDynamicRun;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreWatcher;
import dev.galasa.framework.spi.IResourcePoolingService;
import dev.galasa.framework.spi.InsufficientResourcesAvailableException;
import dev.galasa.framework.spi.ResourcePoolingServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;

public class FrameworkResourcePoolingService
implements IResourcePoolingService {
    private static final int DEFAULTNUMBEROFRESOURCES = 10;
    private static final int DEFAULTCONSECUTIVERESOURCES = 1;
    private IDynamicStatusStoreService defaultDss = new StubbedDss();
    private String defaultKeyPrefix = "";
    private Random random = new Random();

    @Override
    public List<String> obtainResources(@NotNull List<String> resourceStrings, List<String> rejectedResources) throws InsufficientResourcesAvailableException {
        try {
            List<ResourceString> resourceDefinitions = this.createResourceDefintions(resourceStrings);
            return this.generateResources(resourceDefinitions, rejectedResources, 10, this.defaultDss, this.defaultKeyPrefix, 1);
        }
        catch (DynamicStatusStoreException | ResourcePoolingServiceException e) {
            throw new InsufficientResourcesAvailableException("Could not generate resource Strings from the definitions provided. ", (Throwable)e);
        }
    }

    @Override
    public List<String> obtainResources(@NotNull List<String> resourceStrings, List<String> rejectedResources, IDynamicStatusStoreService dss, String keyPrefix) throws InsufficientResourcesAvailableException {
        try {
            List<ResourceString> resourceDefinitions = this.createResourceDefintions(resourceStrings);
            return this.generateResources(resourceDefinitions, rejectedResources, 10, dss, keyPrefix, 1);
        }
        catch (DynamicStatusStoreException | ResourcePoolingServiceException e) {
            throw new InsufficientResourcesAvailableException("Could not generate resource Strings from the definitions provided. ", (Throwable)e);
        }
    }

    @Override
    public List<String> obtainResources(@NotNull List<String> resourceStrings, List<String> rejectedResources, int returnMinimum) throws InsufficientResourcesAvailableException {
        try {
            List<ResourceString> resourceDefinitions = this.createResourceDefintions(resourceStrings);
            return this.generateResources(resourceDefinitions, rejectedResources, returnMinimum, this.defaultDss, this.defaultKeyPrefix, 1);
        }
        catch (DynamicStatusStoreException | ResourcePoolingServiceException e) {
            throw new InsufficientResourcesAvailableException("Could not generate resource Strings from the definitions provided. ", (Throwable)e);
        }
    }

    @Override
    public List<String> obtainResources(@NotNull List<String> resourceStrings, List<String> rejectedResources, int returnMinimum, IDynamicStatusStoreService dss, String keyPrefix) throws InsufficientResourcesAvailableException {
        try {
            List<ResourceString> resourceDefinitions = this.createResourceDefintions(resourceStrings);
            return this.generateResources(resourceDefinitions, rejectedResources, returnMinimum, dss, keyPrefix, 1);
        }
        catch (DynamicStatusStoreException | ResourcePoolingServiceException e) {
            throw new InsufficientResourcesAvailableException("Could not generate resource Strings from the definitions provided. ", (Throwable)e);
        }
    }

    @Override
    public List<String> obtainResources(@NotNull List<String> resourceStrings, List<String> rejectedResources, int returnMinimum, int returnConsecutive) throws InsufficientResourcesAvailableException {
        if (returnMinimum % returnConsecutive != 0) {
            throw new InsufficientResourcesAvailableException("The number of consecutive resources required needs to be a multiple of the total number of resources required.");
        }
        try {
            List<ResourceString> resourceDefinitions = this.createResourceDefintions(resourceStrings);
            return this.generateResources(resourceDefinitions, rejectedResources, returnMinimum, this.defaultDss, this.defaultKeyPrefix, returnConsecutive);
        }
        catch (DynamicStatusStoreException | ResourcePoolingServiceException e) {
            throw new InsufficientResourcesAvailableException("Could not generate resource Strings from the definitions provided. ", (Throwable)e);
        }
    }

    @Override
    public List<String> obtainResources(@NotNull List<String> resourceStrings, List<String> rejectedResources, int returnMinimum, int returnConsecutive, IDynamicStatusStoreService dss, String keyPrefix) throws InsufficientResourcesAvailableException {
        if (returnMinimum % returnConsecutive != 0) {
            throw new InsufficientResourcesAvailableException("The number of consecutive resources required needs to be a multiple of the total number of resources required.");
        }
        try {
            List<ResourceString> resourceDefinitions = this.createResourceDefintions(resourceStrings);
            return this.generateResources(resourceDefinitions, rejectedResources, returnMinimum, dss, keyPrefix, returnConsecutive);
        }
        catch (DynamicStatusStoreException | ResourcePoolingServiceException e) {
            throw new InsufficientResourcesAvailableException("Could not generate resource Strings from the definitions provided. ", (Throwable)e);
        }
    }

    private List<ResourceString> createResourceDefintions(List<String> resourceStrings) throws ResourcePoolingServiceException {
        ArrayList<ResourceString> list = new ArrayList<ResourceString>();
        for (String input : resourceStrings) {
            list.add(new ResourceString(input));
        }
        return list;
    }

    private List<String> generateResources(List<ResourceString> resourceDefinitions, List<String> rejectedResources, int numberOfResources, IDynamicStatusStoreService dss, String keyPrefix, int returnConsecutive) throws DynamicStatusStoreException, InsufficientResourcesAvailableException {
        ArrayList<String> generatedResources = new ArrayList<String>();
        ArrayList<String> bannedResources = new ArrayList<String>();
        if (rejectedResources == null) {
            rejectedResources = new ArrayList<String>();
        }
        bannedResources.addAll(rejectedResources);
        try {
            for (int i = 0; i < numberOfResources; i += returnConsecutive) {
                ResourceString randomDefinition = resourceDefinitions.get(this.random.nextInt(resourceDefinitions.size()));
                List<String> newResources = this.generateRandomResources(randomDefinition, bannedResources, dss, keyPrefix, returnConsecutive);
                generatedResources.addAll(newResources);
                bannedResources.addAll(newResources);
            }
            return generatedResources;
        }
        catch (DynamicStatusStoreException | InsufficientResourcesAvailableException e) {
            bannedResources.clear();
            bannedResources.addAll(rejectedResources);
            generatedResources.clear();
            try {
                for (ResourceString definition : resourceDefinitions) {
                    for (int i = 0; i < numberOfResources && generatedResources.size() != numberOfResources; i += returnConsecutive) {
                        List<String> newResources = this.generateSequentialResources(definition, bannedResources, dss, keyPrefix, returnConsecutive);
                        generatedResources.addAll(newResources);
                        bannedResources.addAll(newResources);
                    }
                    if (generatedResources.size() != numberOfResources) continue;
                    break;
                }
                if (generatedResources.size() != numberOfResources) {
                    throw new InsufficientResourcesAvailableException("There is not enough available resource.");
                }
                return generatedResources;
            }
            catch (DynamicStatusStoreException | InsufficientResourcesAvailableException e2) {
                throw new InsufficientResourcesAvailableException("There is not enough resource available", (Throwable)e2);
            }
        }
    }

    private List<String> generateRandomResources(ResourceString definition, List<String> bannedReosurceStrings, IDynamicStatusStoreService dss, String keyPrefix, int returnConsecutive) throws DynamicStatusStoreException, InsufficientResourcesAvailableException {
        String randomResource = definition.getRandomResource();
        ArrayList<String> resources = new ArrayList<String>();
        int attempts = 0;
        while (resources.size() < returnConsecutive) {
            if (!bannedReosurceStrings.contains(randomResource) && dss.get(keyPrefix + randomResource) == null) {
                resources.add(randomResource);
            } else {
                resources.clear();
                ++attempts;
                if ((double)(attempts / definition.getNumberOfCombinations()) > 0.4) {
                    throw new InsufficientResourcesAvailableException("Random generation is hitting too many banned resoruces");
                }
            }
            if (resources.size() >= returnConsecutive) continue;
            try {
                randomResource = definition.getNextResource();
            }
            catch (InsufficientResourcesAvailableException e) {
                resources.clear();
                randomResource = definition.getNextResource();
            }
        }
        return resources;
    }

    private List<String> generateSequentialResources(ResourceString definition, List<String> bannedReosurceStrings, IDynamicStatusStoreService dss, String keyPrefix, int returnConsecutive) throws DynamicStatusStoreException, InsufficientResourcesAvailableException {
        String resource = definition.getFirstResource();
        ArrayList<String> resources = new ArrayList<String>();
        int attempt = 0;
        while (resources.size() < returnConsecutive) {
            if (!bannedReosurceStrings.contains(resource) && dss.get(keyPrefix + resource) == null) {
                resources.add(resource);
            } else {
                resources.clear();
                if (++attempt > definition.getNumberOfCombinations()) {
                    return new ArrayList<String>();
                }
            }
            if (resources.size() >= returnConsecutive) continue;
            try {
                resource = definition.getNextResource();
            }
            catch (InsufficientResourcesAvailableException e) {
                resources.clear();
                resource = definition.getNextResource();
                ++attempt;
            }
        }
        return resources;
    }

    private class StubbedDss
    implements IDynamicStatusStoreService {
        private StubbedDss() {
        }

        @Override
        public IDynamicResource getDynamicResource(String input) {
            return null;
        }

        @Override
        public IDynamicRun getDynamicRun() throws DynamicStatusStoreException {
            return null;
        }

        @Override
        public void deletePrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        }

        @Override
        public void delete(@NotNull Set<String> keys) throws DynamicStatusStoreException {
        }

        @Override
        public void delete(@NotNull String key) throws DynamicStatusStoreException {
        }

        @Override
        @NotNull
        public Map<String, String> getPrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
            return new HashMap<String, String>();
        }

        @Override
        public String get(@NotNull String key) throws DynamicStatusStoreException {
            return null;
        }

        @Override
        public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue, @NotNull Map<String, String> others) throws DynamicStatusStoreException {
            return true;
        }

        @Override
        public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue) throws DynamicStatusStoreException {
            return true;
        }

        @Override
        public void put(@NotNull Map<String, String> keyValues) throws DynamicStatusStoreException {
        }

        @Override
        public void put(@NotNull String key, @NotNull String value) throws DynamicStatusStoreException {
        }

        @Override
        public UUID watch(IDynamicStatusStoreWatcher watcher, String key) throws DynamicStatusStoreException {
            return null;
        }

        @Override
        public UUID watchPrefix(IDynamicStatusStoreWatcher watcher, String keyPrefix) throws DynamicStatusStoreException {
            return null;
        }

        @Override
        public void unwatch(UUID watchId) throws DynamicStatusStoreException {
        }

        @Override
        public void performActions(IDssAction ... actions) throws DynamicStatusStoreException {
        }
    }
}

