/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin;

import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunManagers;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IGherkinExecutable;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.gherkin.GherkinFeature;
import dev.galasa.framework.spi.language.gherkin.GherkinFileReader;
import dev.galasa.framework.spi.language.gherkin.GherkinMethod;
import dev.galasa.framework.spi.language.gherkin.IGherkinFileReader;
import dev.galasa.framework.spi.language.gherkin.parser.GherkinLexicalScanner;
import dev.galasa.framework.spi.language.gherkin.parser.GherkinParser;
import dev.galasa.framework.spi.language.gherkin.parser.ParseToken;
import dev.galasa.framework.spi.language.gherkin.xform.ParseTreeTransform;
import dev.galasa.framework.spi.language.gherkin.xform.ParseTreeVisitorPrinter;
import dev.galasa.framework.spi.teststructure.TestGherkinMethod;
import dev.galasa.framework.spi.teststructure.TestStructure;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GherkinTest {
    private Log logger = LogFactory.getLog(GherkinTest.class);
    private GherkinFeature feature;
    private URI gherkinUri;
    private TestStructure testStructure;
    private Result result;
    public static final String LOG_STARTING = "Starting";
    public static final String LOG_ENDING = "Ending";
    public static final String LOG_START_LINE = "\n" + StringUtils.repeat((String)"-", (int)23) + " ";
    public static final String LOG_ASTERS = StringUtils.repeat((String)"*", (int)100);

    public GherkinTest(IRun run, TestStructure testStructure) throws TestRunException {
        this(run, testStructure, new GherkinFileReader());
    }

    protected GherkinTest(IRun run, TestStructure testStructure, IGherkinFileReader fileReader) throws TestRunException {
        this.testStructure = testStructure;
        List<String> lines = this.getGherkinFeatureTextLines(run, fileReader);
        this.feature = this.parseFeature(lines);
        ArrayList<TestGherkinMethod> structureMethods = new ArrayList<TestGherkinMethod>(this.feature.getScenarios().size());
        for (GherkinMethod scenario : this.feature.getScenarios()) {
            structureMethods.add(scenario.getStructure());
        }
        this.testStructure.setTestShortName(this.feature.getName());
        this.testStructure.setGherkinMethods(structureMethods);
    }

    private GherkinFeature parseFeature(List<String> lines) throws TestRunException {
        GherkinLexicalScanner lexer = new GherkinLexicalScanner(lines);
        GherkinParser parser = new GherkinParser(lexer);
        ParseToken rootToken = parser.Parse();
        ParseTreeVisitorPrinter printer = new ParseTreeVisitorPrinter();
        printer.visit(rootToken);
        String parseTreeText = printer.getResults();
        this.logger.info((Object)parseTreeText);
        ParseTreeTransform transform = new ParseTreeTransform();
        transform.visit(rootToken);
        GherkinFeature feature = transform.getFeature();
        return feature;
    }

    public String getName() {
        return this.feature.getName();
    }

    public List<GherkinMethod> getMethods() {
        return this.feature.getScenarios();
    }

    public List<IGherkinExecutable> getAllExecutables() {
        ArrayList<IGherkinExecutable> allExecutables = new ArrayList<IGherkinExecutable>();
        for (GherkinMethod scenario : this.feature.getScenarios()) {
            allExecutables.addAll(scenario.getExecutables());
        }
        return allExecutables;
    }

    public Boolean allMethodsRegistered() {
        Boolean allRegistered = true;
        for (IGherkinExecutable executable : this.getAllExecutables()) {
            if (executable.getRegisteredManager() != null) continue;
            allRegistered = false;
        }
        return allRegistered;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void runTestMethods(TestRunManagers managers) throws TestRunException {
        String report = this.testStructure.gherkinReport(LOG_START_LINE);
        this.logger.trace((Object)("Test Class structure:-" + report));
        this.logger.info((Object)(LOG_STARTING + LOG_START_LINE + LOG_ASTERS + LOG_START_LINE + "*** Start of feature file: " + this.feature.getName() + LOG_START_LINE + LOG_ASTERS));
        try {
            managers.startOfTestClass();
        }
        catch (FrameworkException e) {
            throw new TestRunException("Unable to inform managers of start of test class", e);
        }
        for (GherkinMethod method : this.feature.getScenarios()) {
            if (this.feature.getVariables().getNumberOfInstances() >= 1) {
                method.invoke(managers, this.feature.getVariables().getVariableInstance(0));
            } else {
                method.invoke(managers, this.feature.getVariables().getVariablesOriginal());
            }
            if (!method.fullStop()) continue;
            break;
        }
        for (GherkinMethod method : this.feature.getScenarios()) {
            Result methodResult = method.getResult();
            if (methodResult == null || !methodResult.isFailed()) continue;
            this.result = Result.failed("A Test failed");
            break;
        }
        if (this.result == null) {
            this.result = Result.passed();
        }
        try {
            Result newResult = managers.endOfTestClass(this.result, null);
            if (newResult != null) {
                this.logger.info((Object)("Result of test run overridden to " + newResult));
                this.result = newResult;
            }
        }
        catch (FrameworkException e) {
            throw new TestRunException("Problem with end of test class", e);
        }
        this.logger.info((Object)(LOG_ENDING + LOG_START_LINE + LOG_ASTERS + LOG_START_LINE + "*** " + this.result.getName() + " - Test class " + this.feature.getName() + LOG_START_LINE + LOG_ASTERS));
        this.testStructure.setResult(this.result.getName());
        managers.testClassResult(this.result, null);
        String postReport = this.testStructure.gherkinReport(LOG_START_LINE);
        this.logger.trace((Object)("Finishing Test Class structure:-" + postReport));
    }

    private List<String> getGherkinFeatureTextLines(IRun run, IGherkinFileReader fileReader) throws TestRunException {
        String gherkinUriString = run.getGherkin();
        if (gherkinUriString == null) {
            throw new TestRunException("Gherkin URI is not set");
        }
        try {
            this.gherkinUri = new URI(gherkinUriString);
        }
        catch (URISyntaxException e) {
            throw new TestRunException("Unable to parse gherkin test URI", e);
        }
        String schema = this.gherkinUri.getScheme();
        if (schema == null) {
            throw new TestRunException("Gherkin URI " + this.gherkinUri + " does not contain a schema");
        }
        if (!"file".equals(schema)) {
            throw new TestRunException("Gherkin URI scheme " + schema + " is not supported");
        }
        List<String> lines = fileReader.readLines(this.gherkinUri);
        return lines;
    }
}

