/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GherkinVariables {
    private static final Pattern exampleInstancePattern = Pattern.compile("\\|\\ *([a-zA-Z0-9 ]+)");
    private ArrayList<String> columns = new ArrayList();
    public Map<String, ArrayList<String>> variables = new HashMap<String, ArrayList<String>>();

    public void processHeaderLine(String headerLine) {
        ArrayList<String> elements = this.splitExampleData(headerLine);
        for (String element : elements) {
            this.variables.put(element.trim(), new ArrayList());
            this.columns.add(element.trim());
        }
    }

    public void processDataLine(String dataLine) {
        ArrayList<String> elements = this.splitExampleData(dataLine);
        int column = 0;
        for (String element : elements) {
            String key = this.columns.get(column);
            this.variables.get(key).add(element.trim());
            ++column;
        }
    }

    private ArrayList<String> splitExampleData(String line) {
        ArrayList<String> bits = new ArrayList<String>();
        Matcher exampleInstanceMatcher = exampleInstancePattern.matcher(line);
        while (exampleInstanceMatcher.find()) {
            bits.add(exampleInstanceMatcher.group(1));
        }
        return bits;
    }

    public Map<String, ArrayList<String>> getVariables() {
        return this.variables;
    }

    public int getNumberOfInstances() {
        try {
            return this.variables.entrySet().iterator().next().getValue().size();
        }
        catch (NoSuchElementException nsee) {
            return 0;
        }
    }

    public Map<String, Object> getVariableInstance(int instance) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.variables.keySet()) {
            result.put(key, this.variables.get(key).get(instance));
        }
        return result;
    }

    public Map<String, Object> getVariablesOriginal() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String s : this.getVariables().keySet()) {
            result.put(s, this.getVariables().get(s));
        }
        return result;
    }
}

