/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin.parser;

import dev.galasa.framework.spi.language.gherkin.parser.DataLineMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.ExamplesTokenMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.FeatureTokenMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.LexicalScanner;
import dev.galasa.framework.spi.language.gherkin.parser.ParseToken;
import dev.galasa.framework.spi.language.gherkin.parser.ScenarioOutlineTokenMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.ScenarioTokenMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.StepLineMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.TokenMatcher;
import dev.galasa.framework.spi.language.gherkin.parser.TokenType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GherkinLexicalScanner
implements LexicalScanner {
    private List<String> lines;
    private Iterator<String> linesWalker;
    private int lineNumber;
    private static final Log logger = LogFactory.getLog(GherkinLexicalScanner.class);
    private List<TokenMatcher> tokenMatchers = List.of(new FeatureTokenMatcher(), new ScenarioTokenMatcher(), new ScenarioOutlineTokenMatcher(), new ExamplesTokenMatcher(), new DataLineMatcher(), new StepLineMatcher());
    private Stack<ParseToken> tokenStack = new Stack();

    public GherkinLexicalScanner(List<String> lines) {
        this.lines = lines == null ? new ArrayList<String>() : lines;
        this.linesWalker = this.lines.iterator();
        this.lineNumber = 0;
    }

    @Override
    public ParseToken getNextToken() {
        ParseToken token = null;
        token = !this.tokenStack.empty() ? this.tokenStack.pop() : this.getNextTokenFromLines();
        if (token.getType() == TokenType.END_OF_FILE) {
            this.tokenStack.push(token);
        }
        logger.debug((Object)("Lex: GetToken: Returning " + token.toString()));
        return token;
    }

    private ParseToken getNextTokenFromLines() {
        ParseToken token = null;
        while (token == null) {
            TokenMatcher tokenMatcher;
            String line = this.getNextLine();
            if (line == null) {
                token = new ParseToken(TokenType.END_OF_FILE, "");
                continue;
            }
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            Iterator<TokenMatcher> iterator = this.tokenMatchers.iterator();
            while (iterator.hasNext() && (token = (tokenMatcher = iterator.next()).matches(line)) == null) {
            }
        }
        token.setLineNumber(this.lineNumber);
        return token;
    }

    private String getNextLine() {
        String line = null;
        ++this.lineNumber;
        if (this.linesWalker.hasNext()) {
            line = this.linesWalker.next();
        }
        return line;
    }

    @Override
    public void pushBackToken(ParseToken token) {
        logger.debug((Object)("Lex: pushBackToken: Pushing back token " + token.toString()));
        this.tokenStack.push(token);
    }
}

