/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin.parser;

import dev.galasa.framework.TestRunException;
import dev.galasa.framework.spi.language.gherkin.parser.LexicalScanner;
import dev.galasa.framework.spi.language.gherkin.parser.ParseToken;
import dev.galasa.framework.spi.language.gherkin.parser.TokenType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GherkinParser {
    private final LexicalScanner lex;
    private final Stack<ParseToken> tokens = new Stack();
    private static final Log logger = LogFactory.getLog(GherkinParser.class);

    public GherkinParser(LexicalScanner lex) {
        this.lex = lex;
    }

    public void shift(ParseToken token) {
        logger.debug((Object)("Parser: shifting token " + token.toString()));
        this.tokens.add(token);
    }

    public void reduce(int tokensToReduce, ParseToken parentToken) {
        logger.debug((Object)("Parser: reducing " + Integer.toString(tokensToReduce)));
        ArrayList<ParseToken> children = new ArrayList<ParseToken>();
        while (tokensToReduce > 0) {
            ParseToken token = this.tokens.pop();
            children.add(0, token);
            --tokensToReduce;
        }
        parentToken.addChildren(children);
        this.parentTokenInheritsChildAttributes(parentToken);
        for (ParseToken childToken : parentToken.children) {
            logger.debug((Object)("Parser:   child: " + childToken.toString()));
        }
        this.shift(parentToken);
    }

    private void parentTokenInheritsChildAttributes(ParseToken parentToken) {
        List<ParseToken> children = parentToken.getChildren();
        if (children.size() > 0) {
            ParseToken firstChild = children.get(0);
            parentToken.setLineNumber(firstChild.getLineNumber());
            parentToken.setText(firstChild.getText());
        }
    }

    public ParseToken Parse() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case FEATURE_START: {
                this.shift(token);
                this.parseScenarioPartList();
                ParseToken token2 = this.lex.getNextToken();
                if (token2.getType() != TokenType.END_OF_FILE) {
                    String msg = MessageFormat.format("GHER001: Unexpected token {0}", token2);
                    this.error(msg);
                }
                this.reduce(2, new ParseToken(TokenType.FEATURE, token.getText(), token.getLineNumber()));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER002: Expected a `Feature:` token on line {0}", Integer.toString(token.getLineNumber()));
                this.error(msg);
            }
        }
        ParseToken featureToken = this.tokens.pop();
        return featureToken;
    }

    private void parseScenarioPartList() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case END_OF_FILE: {
                this.reduce(0, new ParseToken(TokenType.SCENARIO_PART_LIST, "", token.getLineNumber()));
                break;
            }
            case SCENARIO_START: 
            case SCENARIO_OUTLINE_START: {
                this.lex.pushBackToken(token);
                this.parseScenarioPart();
                this.parseScenarioPartList();
                this.reduce(2, new ParseToken(TokenType.SCENARIO_PART_LIST, ""));
                break;
            }
            case EXAMPLES_START: {
                String msg = MessageFormat.format("GHER012: Unexpected token {0}. Example given outside of a Scenario Outline.", token);
                this.error(msg);
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER003: Unexpected token {0}", token);
                this.error(msg);
            }
        }
    }

    private void parseScenarioPart() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case SCENARIO_START: {
                this.lex.pushBackToken(token);
                this.parseScenario();
                break;
            }
            case SCENARIO_OUTLINE_START: {
                this.lex.pushBackToken(token);
                this.parseScenarioOutline();
                this.reduce(1, new ParseToken(TokenType.SCENARIO_PART, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER004: Unexpected token {0}", token);
                this.error(msg);
            }
        }
    }

    private void parseScenario() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case SCENARIO_START: {
                this.shift(token);
                this.parseStepList();
                this.reduce(2, new ParseToken(TokenType.SCENARIO, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER005: Unexpected token {0}", token);
                this.error(msg);
            }
        }
    }

    private void parseScenarioOutline() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case SCENARIO_OUTLINE_START: {
                this.shift(token);
                this.parseStepList();
                this.expectToken(TokenType.EXAMPLES_START, MessageFormat.format("GHER006: Unexpected token {0}. ''Scenario Outline:'' used without an ''Examples:'' section.", token));
                this.parseDataTable();
                this.reduce(4, new ParseToken(TokenType.SCENARIO_OUTLINE, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER007: Unexpected token {0}", token);
                this.error(msg);
            }
        }
    }

    private void expectToken(TokenType expectedToken, String msgIfMissing) throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        if (token.getType() != expectedToken) {
            this.error(msgIfMissing);
        } else {
            this.shift(token);
        }
    }

    private void parseDataTable() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case DATA_LINE: {
                this.lex.pushBackToken(token);
                this.parseDataHeaderLine();
                this.parseDataValuesLineList();
                this.reduce(2, new ParseToken(TokenType.DATA_TABLE, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER009: Unexpected token {0}. Expected the first line of a data table.", token);
                this.error(msg);
            }
        }
    }

    private void parseDataHeaderLine() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case DATA_LINE: {
                this.shift(token);
                this.reduce(1, new ParseToken(TokenType.DATA_TABLE_HEADER, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER010: Unexpected token {0}. Expected the first line of a data table.", token);
                this.error(msg);
            }
        }
    }

    private void parseDataValuesLineList() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case DATA_LINE: {
                this.shift(token);
                this.parseDataValuesLineList();
                this.reduce(2, new ParseToken(TokenType.DATA_TABLE_LINE_LIST, ""));
                break;
            }
            case END_OF_FILE: 
            case SCENARIO_START: 
            case SCENARIO_OUTLINE_START: {
                this.lex.pushBackToken(token);
                this.reduce(0, new ParseToken(TokenType.DATA_TABLE_LINE_LIST, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER011: Unexpected token {0}. Expected the first line of a data table.", token);
                this.error(msg);
            }
        }
    }

    private void parseStepList() throws TestRunException {
        ParseToken token = this.lex.getNextToken();
        switch (token.getType()) {
            case END_OF_FILE: 
            case SCENARIO_START: 
            case SCENARIO_OUTLINE_START: 
            case EXAMPLES_START: {
                this.lex.pushBackToken(token);
                this.reduce(0, new ParseToken(TokenType.STEP_LIST, "", token.getLineNumber()));
                break;
            }
            case STEP: {
                this.shift(token);
                this.parseStepList();
                this.reduce(2, new ParseToken(TokenType.STEP_LIST, ""));
                break;
            }
            default: {
                String msg = MessageFormat.format("GHER008: Unexpected token {0}", token);
                this.error(msg);
            }
        }
    }

    private void error(String message) throws TestRunException {
        throw new TestRunException(message);
    }
}

