/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.ras;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;

public class ResultArchiveStoreByteChannel
implements SeekableByteChannel {
    private static final String DUMMY_EXCEPTION = "Not available in dummy RAS channel";
    private boolean open = true;
    private int position = 0;

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        throw new IOException(DUMMY_EXCEPTION);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        byte[] data = new byte[src.remaining()];
        src.get(data);
        this.position += data.length;
        return data.length;
    }

    @Override
    public long position() throws IOException {
        return this.size();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        throw new IOException(DUMMY_EXCEPTION);
    }

    @Override
    public long size() throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        throw new IOException(DUMMY_EXCEPTION);
    }
}

