/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.ras;

import dev.galasa.framework.spi.ras.ResultArchiveStoreBasicAttributes;
import dev.galasa.framework.spi.ras.ResultArchiveStoreBasicAttributesView;
import dev.galasa.framework.spi.ras.ResultArchiveStoreByteChannel;
import dev.galasa.framework.spi.ras.ResultArchiveStoreFileSystem;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;

public class ResultArchiveStoreFileSystemProvider
extends FileSystemProvider {
    public static final String NOT_AVAILABLE_MESSAGE = "Not available in a Dummy Result Archive Store";
    private final FileStore fileStore;
    protected FileSystem fileSystem;

    protected ResultArchiveStoreFileSystemProvider(FileStore fileSystemStore) {
        this.fileStore = fileSystemStore;
        this.fileSystem = this.createFileSystem();
    }

    protected ResultArchiveStoreFileSystemProvider(FileStore fileSystemStore, FileSystem fileSystem) {
        this.fileStore = fileSystemStore;
        this.fileSystem = fileSystem;
    }

    protected ResultArchiveStoreFileSystem createFileSystem() {
        return new ResultArchiveStoreFileSystem(this);
    }

    public FileStore getActualFileStore() {
        return this.fileStore;
    }

    @Override
    public String getScheme() {
        return "rasdummy";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return this.fileSystem;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.fileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        return this.getActualFileSystem().newPathObject(uri.getPath());
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return new ResultArchiveStoreByteChannel();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        throw new UnsupportedOperationException(NOT_AVAILABLE_MESSAGE);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new UnsupportedOperationException("Not allowed to delete artifacts from the Result Archive Store");
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException(NOT_AVAILABLE_MESSAGE);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException(NOT_AVAILABLE_MESSAGE);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return path.compareTo(path2) == 0;
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.fileStore;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (modes.length == 0) {
            throw new IOException("File does not exist in Dummy RAS");
        }
        block5: for (AccessMode mode : modes) {
            switch (mode) {
                case EXECUTE: {
                    throw new UnsupportedOperationException("Path '" + path.toString() + " is not executable");
                }
                case READ: {
                    throw new UnsupportedOperationException("Path '" + path.toString() + " is not available read in dummy RAS");
                }
                case WRITE: {
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == BasicFileAttributeView.class) {
            return (V)new ResultArchiveStoreBasicAttributesView();
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return (A)new ResultArchiveStoreBasicAttributes();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return null;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not available in a Result Archive Store");
    }

    public ResultArchiveStoreFileSystem getActualFileSystem() {
        return (ResultArchiveStoreFileSystem)this.fileSystem;
    }
}

