/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.utils;

import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DssUtils {
    private static final Log logger = LogFactory.getLog(DssUtils.class);

    public static void incrementMetric(IDynamicStatusStoreService dss, String metric) {
        try {
            DssUtils.incrementProperty(dss, metric);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to update metric", (Throwable)e);
        }
    }

    public static void incrementProperty(IDynamicStatusStoreService dss, String property) throws DynamicStatusStoreException {
        while (true) {
            long oldValue = 0L;
            String sOldValue = AbstractManager.nulled(dss.get(property));
            if (sOldValue != null) {
                oldValue = Long.parseLong(sOldValue);
            }
            if (dss.putSwap(property, sOldValue, Long.toString(++oldValue))) {
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DynamicStatusStoreException("Swap wait interrupted", (Throwable)e);
            }
        }
    }
}

