/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.ResultArchiveStoreContentType;
import dev.galasa.framework.IBundleManager;
import dev.galasa.framework.IFileSystem;
import dev.galasa.framework.ITestRunnerDataProvider;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunHeartbeat;
import dev.galasa.framework.TestRunLifecycleStatus;
import dev.galasa.framework.beans.Property;
import dev.galasa.framework.internal.runner.ITestRunnerEventsProducer;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResultArchiveStore;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.IShuttableFramework;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.DssUtils;
import dev.galasa.framework.spi.utils.GalasaGson;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class BaseTestRunner {
    private Log logger = LogFactory.getLog(BaseTestRunner.class);
    protected BundleContext bundleContext;
    protected IShuttableFramework framework;
    protected IBundleManager bundleManager;
    protected IFileSystem fileSystem;
    protected IConfigurationPropertyStoreService cps;
    protected IDynamicStatusStoreService dss;
    protected IResultArchiveStore ras;
    protected IRun run;
    protected TestStructure testStructure;
    protected TestRunHeartbeat heartbeat;
    protected boolean isRunOK = true;
    protected boolean isResourcesAvailable = true;
    private ITestRunnerEventsProducer eventsProducer;
    protected Properties overrideProperties;
    private static final GalasaGson gson = new GalasaGson();

    protected void init(ITestRunnerDataProvider dataProvider) throws TestRunException {
        this.run = dataProvider.getRun();
        this.framework = dataProvider.getFramework();
        this.cps = dataProvider.getCPS();
        this.ras = dataProvider.getRAS();
        this.dss = dataProvider.getDSS();
        this.bundleManager = dataProvider.getBundleManager();
        this.fileSystem = dataProvider.getFileSystem();
        this.overrideProperties = dataProvider.getOverrideProperties();
        this.eventsProducer = dataProvider.getEventsProducer();
        this.checkRunIsSet(this.run);
        this.loadOverrideProperties(this.overrideProperties, this.run, this.dss);
    }

    protected void shutdownFramework(IShuttableFramework framework) {
        try {
            framework.shutdown();
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Problem shutting down the Galasa framework", (Throwable)e);
        }
    }

    protected void saveUsedCPSPropertiesToArtifact(Properties props, IFileSystem fileSystem, IResultArchiveStore ras) {
        String titleText = "The properties used by the test and managers.";
        String fileName = "cps_record.properties";
        this.savePropertiesToFile(ras, props, titleText, fileName, fileSystem);
    }

    protected void saveAllOverridesPassedToArtifact(Properties overrides, IFileSystem fileSystem, IResultArchiveStore ras) {
        String titleText = "The properties passed as overrides to the test";
        String fileName = "overrides.properties";
        this.savePropertiesToFile(ras, overrides, titleText, fileName, fileSystem);
    }

    private void savePropertiesToFile(IResultArchiveStore ras, Properties props, String titleText, String fileName, IFileSystem fileSystem) {
        try {
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.addAll(props.stringPropertyNames());
            Collections.sort(propertyNames);
            StringBuilder sb = new StringBuilder();
            sb.append("# ");
            sb.append(titleText);
            sb.append("\n\n");
            String currentNamespace = null;
            for (String propertyName : propertyNames) {
                if ((propertyName = propertyName.trim()).isEmpty()) continue;
                String[] parts = propertyName.split("\\.");
                if (!parts[0].equals(currentNamespace)) {
                    if (currentNamespace != null) {
                        sb.append("\n");
                    }
                    currentNamespace = parts[0];
                }
                sb.append(propertyName);
                sb.append("=");
                sb.append(props.getProperty(propertyName));
                sb.append("\n");
            }
            Path rasRoot = ras.getStoredArtifactsRoot();
            Path rasProperties = rasRoot.resolve("framework").resolve(fileName);
            fileSystem.createFile(rasProperties, new FileAttribute[]{ResultArchiveStoreContentType.TEXT});
            fileSystem.write(rasProperties, sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to save the " + fileName + " properties. " + titleText), (Throwable)e);
        }
    }

    private void checkRunIsSet(IRun run) throws TestRunException {
        if (run == null) {
            throw new TestRunException("Unable to locate run properties");
        }
    }

    private void loadOverrideProperties(Properties overrideProperties, IRun run, IDynamicStatusStoreService dss) throws TestRunException {
        try {
            String runOverridesProp = "run." + run.getName() + ".overrides";
            String runOverrides = dss.get(runOverridesProp);
            if (runOverrides != null && !runOverrides.isBlank()) {
                Property[] properties;
                for (Property override : properties = gson.fromJson(runOverrides, Property[].class)) {
                    overrideProperties.put(override.getKey(), override.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new TestRunException("Problem loading overrides from the run properties", e);
        }
    }

    protected TestStructure createNewTestStructure(IRun run) {
        TestStructure testStructure = new TestStructure();
        String runName = run.getName();
        Instant queuedAt = run.getQueued();
        String requestor = AbstractManager.defaultString(run.getRequestor(), "unknown");
        testStructure.setQueued(queuedAt);
        testStructure.setStartTime(Instant.now());
        testStructure.setRunName(runName);
        testStructure.setRequestor(requestor);
        return testStructure;
    }

    protected void writeTestStructure() {
        try {
            this.ras.updateTestStructure(this.testStructure);
        }
        catch (ResultArchiveStoreException e) {
            this.logger.warn((Object)"Unable to write the test structure to the RAS", (Throwable)e);
        }
    }

    protected void deleteRunProperties(@NotNull IFramework framework) {
        IRun run = framework.getTestRun();
        if (!run.isLocal()) {
            return;
        }
        try {
            framework.getFrameworkRuns().delete(run.getName());
        }
        catch (FrameworkException e) {
            this.logger.error((Object)"Failed to delete run properties");
        }
    }

    protected String getDSSKeyString(String keySuffix) {
        return "run." + this.run.getName() + "." + keySuffix;
    }

    protected void stopHeartbeat() {
        if (this.heartbeat == null) {
            return;
        }
        this.heartbeat.shutdown();
        try {
            this.heartbeat.join(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dss.delete("run." + this.run.getName() + ".heartbeat");
        }
        catch (DynamicStatusStoreException e) {
            this.logger.error((Object)"Unable to delete heartbeat", (Throwable)e);
        }
        try {
            this.eventsProducer.produceTestHeartbeatStoppedEvent(this.framework.getTestRunName());
        }
        catch (TestRunException e) {
            this.logger.error((Object)"Unable to produce a test heartbeat stopped event to the Events Service", (Throwable)e);
        }
    }

    protected void markWaiting(@NotNull IFramework framework) throws TestRunException {
        int initialDelay = 600;
        int randomDelay = 180;
        DssUtils.incrementMetric(this.dss, "metrics.runs.made.to.wait");
        try {
            String sInitialDelay = AbstractManager.nulled(this.cps.getProperty("waiting.initial", "delay", new String[0]));
            String sRandomDelay = AbstractManager.nulled(this.cps.getProperty("waiting.random", "delay", new String[0]));
            if (sInitialDelay != null) {
                initialDelay = Integer.parseInt(sInitialDelay);
            }
            if (sRandomDelay != null) {
                randomDelay = Integer.parseInt(sRandomDelay);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem reading delay properties", (Throwable)e);
        }
        int totalDelay = initialDelay + framework.getRandom().nextInt(randomDelay);
        this.logger.info((Object)("Placing this run on waiting for " + totalDelay + " seconds"));
        Instant until = Instant.now();
        until = until.plus((long)totalDelay, ChronoUnit.SECONDS);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(this.getDSSKeyString("status"), "waiting");
        properties.put(this.getDSSKeyString("wait.until"), until.toString());
        try {
            this.dss.put(properties);
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Unable to place run in waiting state", e);
        }
    }

    protected void updateResult() throws TestRunException {
        try {
            if (this.testStructure.getResult() == null) {
                this.testStructure.setResult("UNKNOWN");
            }
            this.dss.put("run." + this.run.getName() + ".result", this.testStructure.getResult());
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update result", e);
        }
    }

    protected IFramework getFramework() {
        return this.framework;
    }

    public IConfigurationPropertyStoreService getCPS() {
        return this.cps;
    }

    protected void updateStatus(TestRunLifecycleStatus status, String dssTimePropSuffix) throws TestRunException {
        Instant time = Instant.now();
        this.testStructure.setStatus(status.toString());
        if ("finished".equals(status.toString())) {
            this.updateResult();
            this.testStructure.setEndTime(Instant.now());
        }
        this.writeTestStructure();
        try {
            this.dss.put(this.getDSSKeyString("status"), status.toString());
            if (dssTimePropSuffix != null) {
                this.dss.put(this.getDSSKeyString(dssTimePropSuffix), time.toString());
            }
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update status", e);
        }
        this.eventsProducer.produceTestRunLifecycleStatusChangedEvent(this.framework.getTestRunName(), status);
    }

    protected void incrimentMetric(IDynamicStatusStoreService dss, IRun run) {
        if (run.isLocal()) {
            this.logger.debug((Object)"It's a local test");
            DssUtils.incrementMetric(dss, "metrics.runs.local");
        } else {
            this.logger.debug((Object)"It's an automated test");
            DssUtils.incrementMetric(dss, "metrics.runs.automated");
        }
    }

    protected void storeRasRunIdInDss(IDynamicStatusStoreService dss, String rasRunId) throws TestRunException {
        try {
            this.dss.put("run." + this.run.getName() + ".rasrunid", rasRunId);
        }
        catch (DynamicStatusStoreException e) {
            throw new TestRunException("Failed to update rasrunid", e);
        }
    }

    protected TestRunHeartbeat createBeatingHeart(IFramework framework) throws TestRunException {
        TestRunHeartbeat heartbeat;
        try {
            heartbeat = new TestRunHeartbeat(framework);
            heartbeat.start();
        }
        catch (DynamicStatusStoreException ex) {
            throw new TestRunException("Unable to initialise the heartbeat. " + ex.getMessage(), ex);
        }
        return heartbeat;
    }
}

