/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.FileSystem;
import dev.galasa.framework.Framework;
import dev.galasa.framework.IFileSystem;
import dev.galasa.framework.beans.Property;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.CertificateStoreException;
import dev.galasa.framework.spi.ConfidentialTextException;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.Environment;
import dev.galasa.framework.spi.EventsException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.ICertificateStoreService;
import dev.galasa.framework.spi.IConfidentialTextService;
import dev.galasa.framework.spi.IConfidentialTextServiceRegistration;
import dev.galasa.framework.spi.IConfigurationPropertyStore;
import dev.galasa.framework.spi.IConfigurationPropertyStoreRegistration;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreRegistration;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IEventsService;
import dev.galasa.framework.spi.IEventsServiceRegistration;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IResultArchiveStoreRegistration;
import dev.galasa.framework.spi.IResultArchiveStoreService;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.IShuttableFramework;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.SystemEnvironment;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsStore;
import dev.galasa.framework.spi.creds.ICredentialsStoreRegistration;
import dev.galasa.framework.spi.utils.GalasaGson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FrameworkInitialisation
implements IFrameworkInitialisation {
    private static final String USER_HOME = "user.home";
    protected Framework framework;
    private final URI uriConfigurationPropertyStore;
    private final URI uriDynamicStatusStore;
    private final URI uriCredentialsStore;
    private final List<URI> uriResultArchiveStores;
    private final IConfigurationPropertyStoreService cpsFramework;
    private final IDynamicStatusStoreService dssFramework;
    private Log logger;
    private IFileSystem fileSystem;
    private String galasaHome;
    private static final GalasaGson gson = new GalasaGson();

    public FrameworkInitialisation(Properties bootstrapProperties, Properties overrideProperties) throws URISyntaxException, InvalidSyntaxException, FrameworkException {
        this(bootstrapProperties, overrideProperties, false, null, FrameworkInitialisation.getBundleContext(), new FileSystem(), new SystemEnvironment());
    }

    public FrameworkInitialisation(Properties bootstrapProperties, Properties overrideProperties, boolean testrun) throws URISyntaxException, InvalidSyntaxException, FrameworkException {
        this(bootstrapProperties, overrideProperties, testrun, null, FrameworkInitialisation.getBundleContext(), new FileSystem(), new SystemEnvironment());
    }

    public FrameworkInitialisation(Properties bootstrapProperties, Properties overrideProperties, boolean testrun, Log initLogger) throws URISyntaxException, InvalidSyntaxException, FrameworkException {
        this(bootstrapProperties, overrideProperties, testrun, initLogger, FrameworkInitialisation.getBundleContext(), new FileSystem(), new SystemEnvironment());
    }

    public FrameworkInitialisation(Properties bootstrapProperties, Properties overrideProperties, boolean testrun, Log initLogger, BundleContext bundleContext, IFileSystem fileSystem, Environment env) throws URISyntaxException, InvalidSyntaxException, FrameworkException {
        this.fileSystem = fileSystem;
        this.logger = initLogger == null ? LogFactory.getLog(this.getClass()) : initLogger;
        this.galasaHome = bootstrapProperties.getProperty("framework.galasa.home");
        if (this.galasaHome == null) {
            this.galasaHome = this.getGalasaHome(env);
        }
        this.logger.info((Object)("Galasa home folder is " + this.galasaHome));
        overrideProperties.putAll((Map<?, ?>)bootstrapProperties);
        this.logger.info((Object)"Initialising the Galasa Framework");
        this.framework = this.locateFramework(bundleContext);
        this.assertFrameworkNotAlreadyInitialised(this.framework);
        this.framework.setFrameworkProperties(overrideProperties);
        if (testrun) {
            this.framework.installLogCapture();
        }
        this.uriConfigurationPropertyStore = this.locateConfigurationPropertyStore(this.logger, overrideProperties, this.fileSystem);
        this.cpsFramework = this.initialiseConfigurationPropertyStore(this.logger, bundleContext);
        this.uriDynamicStatusStore = this.locateDynamicStatusStore(this.logger, overrideProperties, this.cpsFramework, this.fileSystem);
        this.dssFramework = this.initialiseDynamicStatusStore(this.logger, bundleContext);
        if (testrun) {
            String runName = this.locateRunName(this.cpsFramework);
            this.framework.setTestRunName(runName);
        }
        this.uriResultArchiveStores = this.createUriResultArchiveStores(overrideProperties, this.cpsFramework);
        this.logger.debug((Object)("Result Archive Stores are " + this.uriResultArchiveStores.toString()));
        this.initialiseResultsArchiveStore(this.logger, bundleContext);
        this.uriCredentialsStore = this.locateCredentialsStore(this.logger, overrideProperties, this.cpsFramework, this.fileSystem);
        this.initialiseCredentialsStore(this.logger, bundleContext);
        this.initialiseConfidentialTextService(this.logger, bundleContext);
        this.initialiseEventsService(this.logger, bundleContext);
        if (this.framework.isInitialised()) {
            this.logger.info((Object)"Framework initialised");
        } else {
            this.logger.info((Object)"The Framework does not think it is initialised, but we didn't get any errors");
        }
        if (testrun) {
            this.loadOverridePropertiesFromDss(overrideProperties);
        }
    }

    private void loadOverridePropertiesFromDss(Properties overrideProperties) throws DynamicStatusStoreException {
        String runOverridesProp = "run." + this.framework.getTestRunName() + ".overrides";
        String runOverrides = this.dssFramework.get(runOverridesProp);
        if (runOverrides != null && !runOverrides.isBlank()) {
            Property[] properties;
            for (Property override : properties = gson.fromJson(runOverrides, Property[].class)) {
                String key = override.getKey();
                String value = override.getValue();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Setting run override " + key + "=" + value));
                }
                overrideProperties.put(key, value);
            }
        }
    }

    private static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(FrameworkInitialisation.class).getBundleContext();
    }

    public String getGalasaHome(Environment env) {
        String GALASA_HOME = "GALASA_HOME";
        Object home = env.getProperty(GALASA_HOME);
        if (home == null || ((String)home).trim().isEmpty()) {
            home = env.getenv(GALASA_HOME);
            if (home == null || ((String)home).trim().isEmpty()) {
                String userHome = env.getProperty(USER_HOME);
                if (userHome != null) {
                    this.logger.info((Object)("System property user.home (" + userHome + ") used to set value of home location."));
                    home = userHome + "/.galasa";
                } else {
                    String userProfile = env.getenv("USERPROFILE");
                    if (userProfile != null) {
                        this.logger.info((Object)("System property USERPROFILE (" + userProfile + ") used to set value of home location."));
                        home = userProfile + "/.galasa";
                    } else {
                        this.logger.info((Object)"Defaulting home to ~/.galasa");
                        home = "~/.galasa";
                    }
                }
            } else {
                this.logger.info((Object)"Environment variable GALASA_HOME used to set value of home location.");
            }
        } else {
            this.logger.info((Object)"System property GALASA_HOME used to set value of home location.");
            home = this.stripLeadingAndTrailingQuotes((String)home);
        }
        this.logger.info((Object)("Galasa home location is " + (String)home));
        return home;
    }

    String stripLeadingAndTrailingQuotes(String input) {
        String output = input;
        if (output.startsWith("\"")) {
            output = output.replaceFirst("\"", "");
        }
        if (output.endsWith("\"")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    protected String submitRun(String runBundleClass, String language) throws FrameworkException {
        IRun run = null;
        IFrameworkRuns frameworkRuns = this.framework.getFrameworkRuns();
        switch (language) {
            case "java": {
                String[] split = runBundleClass.split("/");
                String bundle = split[0];
                String test = split[1];
                run = frameworkRuns.submitRun("local", null, bundle, test, null, null, null, null, true, false, null, null, null, language);
                break;
            }
            case "gherkin": {
                run = frameworkRuns.submitRun("local", null, null, runBundleClass, null, null, null, null, true, false, null, null, null, language);
                break;
            }
            default: {
                throw new FrameworkException("Unknown language to create run");
            }
        }
        this.logger.info((Object)("Allocated Run Name " + run.getName() + " to this run"));
        return run.getName();
    }

    private void createIfMissing(URI propertyFile, IFileSystem fileSystem) {
        if (!propertyFile.getScheme().startsWith("file")) {
            return;
        }
        Path path = Paths.get(propertyFile);
        try {
            if (!fileSystem.exists(path)) {
                if (!fileSystem.exists(path.getParent())) {
                    fileSystem.createDirectories(path.getParent());
                }
                this.logger.info((Object)("File " + path.toString() + " does not exist, so creating it."));
                fileSystem.createFile(path);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to create empty default property file " + path.toUri().toString()), (Throwable)e);
        }
    }

    private Framework locateFramework(BundleContext bundleContext) throws FrameworkException {
        ServiceReference frameworkService = bundleContext.getServiceReference(IFramework.class);
        if (frameworkService == null) {
            throw new FrameworkException("The framework service is missing");
        }
        return (Framework)bundleContext.getService(frameworkService);
    }

    @Override
    @NotNull
    public URI getBootstrapConfigurationPropertyStore() {
        return this.uriConfigurationPropertyStore;
    }

    @Override
    public URI getDynamicStatusStoreUri() {
        return this.uriDynamicStatusStore;
    }

    @Override
    public URI getCredentialsStoreUri() {
        return this.uriCredentialsStore;
    }

    @Override
    public List<URI> getResultArchiveStoreUris() {
        return this.uriResultArchiveStores;
    }

    @Override
    public void registerConfigurationPropertyStore(@NotNull IConfigurationPropertyStore configurationPropertyStore) throws ConfigurationPropertyStoreException {
        this.framework.setConfigurationPropertyStore(configurationPropertyStore);
    }

    @Override
    public void registerDynamicStatusStore(@NotNull IDynamicStatusStore dynamicStatusStore) throws DynamicStatusStoreException {
        this.framework.setDynamicStatusStore(dynamicStatusStore);
    }

    @Override
    public void registerResultArchiveStoreService(@NotNull IResultArchiveStoreService resultArchiveStoreService) throws ResultArchiveStoreException {
        this.framework.addResultArchiveStoreService(resultArchiveStoreService);
    }

    @Override
    public void registerConfidentialTextService(@NotNull IConfidentialTextService confidentialTextService) throws ConfidentialTextException {
        this.framework.setConfidentialTextService(confidentialTextService);
    }

    @Override
    public void registerCredentialsStore(@NotNull ICredentialsStore credentialsStore) throws CredentialsException {
        this.framework.setCredentialsStore(credentialsStore);
    }

    @Override
    public void registerEventsService(@NotNull IEventsService eventsService) throws EventsException {
        this.framework.setEventsService(eventsService);
    }

    @Override
    @NotNull
    public IFramework getFramework() {
        return this.framework;
    }

    @NotNull
    public IShuttableFramework getShutableFramework() {
        return this.framework;
    }

    public void shutdownFramework() {
        try {
            this.framework.shutdown(null);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Problem shutting down the Galasa framework", (Throwable)e);
        }
    }

    @Override
    public void registerCertificateStoreService(@NotNull ICertificateStoreService certificateStoreService) throws CertificateStoreException {
    }

    private void assertFrameworkNotAlreadyInitialised(Framework framework) throws FrameworkException {
        if (this.framework.isInitialised()) {
            throw new FrameworkException("The framework has already been initialised");
        }
    }

    URI locateConfigurationPropertyStore(Log logger, Properties overrideProperties, IFileSystem fileSystem) throws URISyntaxException {
        URI storeUri;
        String propUri = overrideProperties.getProperty("framework.config.store");
        if (propUri != null && !propUri.isEmpty()) {
            logger.debug((Object)"bootstrap property framework.config.store used to determine CPS location.");
        }
        if (propUri == null || propUri.isEmpty()) {
            Path path = Paths.get(this.galasaHome, "cps.properties");
            storeUri = path.toUri();
            logger.debug((Object)"galasa home used to determine CPS location.");
            this.createIfMissing(storeUri, fileSystem);
        } else {
            storeUri = new URI(propUri);
        }
        logger.debug((Object)("Configuration Property Store is " + storeUri.toString()));
        return storeUri;
    }

    URI locateDynamicStatusStore(Log logger, Properties overrideProperties, IConfigurationPropertyStoreService cpsFramework, IFileSystem fileSystem) throws FrameworkException {
        URI uriDynamicStatusStore = null;
        try {
            String dssProperty = overrideProperties.getProperty("framework.dynamicstatus.store");
            if (dssProperty != null && !dssProperty.isEmpty()) {
                uriDynamicStatusStore = new URI(dssProperty);
                logger.debug((Object)"Obtained value of DSS from properties");
                logger.debug((Object)("Dynamic Status Store is " + uriDynamicStatusStore.toString()));
                this.createIfMissing(uriDynamicStatusStore, fileSystem);
                return uriDynamicStatusStore;
            }
            dssProperty = cpsFramework.getProperty("dynamicstatus", "store", new String[0]);
            if (dssProperty != null && !dssProperty.isEmpty()) {
                uriDynamicStatusStore = new URI(dssProperty);
                logger.debug((Object)"Obtained value of DSS from CPS");
                logger.debug((Object)("Dynamic Status Store is " + uriDynamicStatusStore.toString()));
                this.createIfMissing(uriDynamicStatusStore, fileSystem);
                return uriDynamicStatusStore;
            }
            uriDynamicStatusStore = Paths.get(this.galasaHome, "dss.properties").toUri();
            logger.debug((Object)("Dynamic Status Store is " + uriDynamicStatusStore.toString()));
            logger.debug((Object)"Obtained value of DSS from galasa home");
            this.createIfMissing(uriDynamicStatusStore, fileSystem);
            return uriDynamicStatusStore;
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to resolve the Dynamic Status Store URI", (Throwable)e);
        }
    }

    private String locateRunName(IConfigurationPropertyStoreService cpsFramework) throws FrameworkException {
        String runName = AbstractManager.nulled(cpsFramework.getProperty("run", "name", new String[0]));
        if (runName == null) {
            String testName = AbstractManager.nulled(cpsFramework.getProperty("run", "testbundleclass", new String[0]));
            String testLanguage = "java";
            if (testName == null) {
                testName = AbstractManager.nulled(cpsFramework.getProperty("run", "gherkintest", new String[0]));
                testLanguage = "gherkin";
            }
            this.logger.info((Object)("Submitting test " + testName));
            runName = this.submitRun(testName, testLanguage);
        }
        this.logger.info((Object)("Run name is " + runName));
        return runName;
    }

    private void processRASlocationProperty(String rasProperty, List<URI> uriResultArchiveStores) throws URISyntaxException {
        if (rasProperty != null && !rasProperty.isEmpty()) {
            String[] rasPaths;
            for (String rasPath : rasPaths = rasProperty.split(",")) {
                if (rasPath.trim().isEmpty()) continue;
                this.logger.debug((Object)("Adding Result Archive Store location " + rasPath));
                uriResultArchiveStores.add(new URI(rasPath));
            }
        }
    }

    List<URI> createUriResultArchiveStores(Properties overrideProperties, IConfigurationPropertyStoreService cpsFramework) throws FrameworkException {
        ArrayList<URI> uriResultArchiveStores = new ArrayList<URI>(1);
        Path localRasPath = Paths.get(this.galasaHome, "ras");
        URI localRasUri = localRasPath.toUri();
        try {
            String rasProperty = overrideProperties.getProperty("framework.resultarchive.store");
            this.processRASlocationProperty(rasProperty, uriResultArchiveStores);
            if (uriResultArchiveStores.isEmpty()) {
                rasProperty = cpsFramework.getProperty("resultarchive", "store", new String[0]);
                this.processRASlocationProperty(rasProperty, uriResultArchiveStores);
            }
            if (uriResultArchiveStores.isEmpty()) {
                uriResultArchiveStores.add(localRasUri);
            }
            if (uriResultArchiveStores.isEmpty()) {
                throw new FrameworkException("No Result Archive Store URIs were provided");
            }
        }
        catch (FrameworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to resolve the Result Archive Store URIs", (Throwable)e);
        }
        boolean includeLocal = Boolean.parseBoolean(cpsFramework.getProperty("resultarchive.store", "include.default.local", new String[0]));
        if (includeLocal && !uriResultArchiveStores.contains(localRasUri)) {
            uriResultArchiveStores.add(localRasUri);
        }
        return uriResultArchiveStores;
    }

    URI locateCredentialsStore(Log logger, Properties overrideProperties, IConfigurationPropertyStoreService cpsFramework, IFileSystem fileSystem) throws FrameworkException {
        URI uriCredentialsStore;
        try {
            String credsProperty = overrideProperties.getProperty("framework.credentials.store");
            if (credsProperty != null && !credsProperty.isEmpty()) {
                URI uriCredentialsStore2 = new URI(credsProperty);
                logger.debug((Object)("Credentials Store (1) is " + uriCredentialsStore2.toString()));
                this.createIfMissing(uriCredentialsStore2, fileSystem);
                return uriCredentialsStore2;
            }
            credsProperty = cpsFramework.getProperty("credentials", "store", new String[0]);
            if (credsProperty != null && !credsProperty.isEmpty()) {
                URI uriCredentialsStore3 = new URI(credsProperty);
                logger.debug((Object)("Credentials Store (2) is " + uriCredentialsStore3.toString()));
                this.createIfMissing(uriCredentialsStore3, fileSystem);
                return uriCredentialsStore3;
            }
            uriCredentialsStore = Paths.get(this.galasaHome, "credentials.properties").toUri();
            this.createIfMissing(uriCredentialsStore, fileSystem);
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to resolve the Credentials Store URI", (Throwable)e);
        }
        logger.debug((Object)("Credentials Store (3) is " + uriCredentialsStore.toString()));
        return uriCredentialsStore;
    }

    IConfigurationPropertyStoreService initialiseConfigurationPropertyStore(Log logger, BundleContext bundleContext) throws FrameworkException, InvalidSyntaxException {
        logger.trace((Object)"Searching for CPS providers");
        ServiceReference[] cpsServiceReference = bundleContext.getAllServiceReferences(IConfigurationPropertyStoreRegistration.class.getName(), null);
        if (cpsServiceReference == null || cpsServiceReference.length == 0) {
            throw new FrameworkException("No Configuration Property Store Services have been found");
        }
        for (ServiceReference cpsReference : cpsServiceReference) {
            IConfigurationPropertyStoreRegistration cpsStoreRegistration = (IConfigurationPropertyStoreRegistration)bundleContext.getService(cpsReference);
            logger.trace((Object)("Found CPS Provider " + cpsStoreRegistration.getClass().getName()));
            cpsStoreRegistration.initialise(this);
        }
        if (this.framework.getConfigurationPropertyStore() == null) {
            throw new FrameworkException("Failed to initialise a Configuration Property Store, unable to continue");
        }
        logger.debug((Object)("Selected CPS Service is " + this.framework.getConfigurationPropertyStore().getClass().getName()));
        return this.framework.getConfigurationPropertyService("framework");
    }

    IDynamicStatusStoreService initialiseDynamicStatusStore(Log logger, BundleContext bundleContext) throws InvalidSyntaxException, FrameworkException {
        logger.trace((Object)"Searching for DSS providers");
        ServiceReference[] dssServiceReference = bundleContext.getAllServiceReferences(IDynamicStatusStoreRegistration.class.getName(), null);
        if (dssServiceReference == null || dssServiceReference.length == 0) {
            throw new FrameworkException("No Dynamic Status Store Services have been found");
        }
        for (ServiceReference dssReference : dssServiceReference) {
            IDynamicStatusStoreRegistration dssStoreRegistration = (IDynamicStatusStoreRegistration)bundleContext.getService(dssReference);
            logger.trace((Object)("Found DSS Provider " + dssStoreRegistration.getClass().getName()));
            dssStoreRegistration.initialise(this);
        }
        if (this.framework.getDynamicStatusStore() == null) {
            throw new FrameworkException("Failed to initialise a Dynamic Status Store, unable to continue");
        }
        logger.trace((Object)("Selected DSS Service is " + this.framework.getDynamicStatusStore().getClass().getName()));
        return this.framework.getDynamicStatusStoreService("framework");
    }

    void initialiseResultsArchiveStore(Log logger, BundleContext bundleContext) throws FrameworkException, InvalidSyntaxException {
        this.logger.trace((Object)"Searching for RAS providers");
        ServiceReference[] rasServiceReference = bundleContext.getAllServiceReferences(IResultArchiveStoreRegistration.class.getName(), null);
        if (rasServiceReference == null || rasServiceReference.length == 0) {
            throw new FrameworkException("No Result Archive Store Services have been found");
        }
        for (ServiceReference rasReference : rasServiceReference) {
            IResultArchiveStoreRegistration rasRegistration = (IResultArchiveStoreRegistration)bundleContext.getService(rasReference);
            if (rasRegistration == null) {
                FrameworkException ex = new FrameworkException(new Exception("Unable to find RAS provider."));
                logger.error((Object)"Unable to find RAS provider.", (Throwable)ex);
                throw ex;
            }
            logger.trace((Object)("Found RAS Provider " + rasRegistration.getClass().getName()));
            rasRegistration.initialise(this);
        }
        if (this.framework.getResultArchiveStoreService() == null) {
            throw new FrameworkException("Failed to initialise a Result Archive Store, unable to continue");
        }
        logger.trace((Object)("Selected RAS Service is " + this.framework.getResultArchiveStoreService().getClass().getName()));
    }

    void initialiseCredentialsStore(Log logger, BundleContext bundleContext) throws FrameworkException, InvalidSyntaxException {
        logger.trace((Object)"Searching for Creds providers");
        ServiceReference[] credsServiceReference = bundleContext.getAllServiceReferences(ICredentialsStoreRegistration.class.getName(), null);
        if (credsServiceReference == null || credsServiceReference.length == 0) {
            throw new FrameworkException("No Credentials Services have been found");
        }
        for (ServiceReference credsReference : credsServiceReference) {
            ICredentialsStoreRegistration credsRegistration = (ICredentialsStoreRegistration)bundleContext.getService(credsReference);
            logger.trace((Object)("Found Creds Provider " + credsRegistration.getClass().getName()));
            credsRegistration.initialise(this);
        }
        if (this.framework.getCredentialsStore() == null) {
            throw new FrameworkException("Failed to initialise a Credentials Store, unable to continue");
        }
        logger.trace((Object)("Selected Credentials Service is " + this.framework.getCredentialsStore().getClass().getName()));
    }

    void initialiseConfidentialTextService(Log logger, BundleContext bundleContext) throws FrameworkException, InvalidSyntaxException {
        logger.trace((Object)"Searching for Confidential Text Service providers");
        ServiceReference[] confidentialServiceReference = bundleContext.getAllServiceReferences(IConfidentialTextServiceRegistration.class.getName(), null);
        if (confidentialServiceReference == null || confidentialServiceReference.length == 0) {
            throw new FrameworkException("No Confidential Text Services have been found");
        }
        for (ServiceReference confidentialReference : confidentialServiceReference) {
            IConfidentialTextServiceRegistration credsRegistration = (IConfidentialTextServiceRegistration)bundleContext.getService(confidentialReference);
            logger.trace((Object)("Found Confidential Text Services Provider " + credsRegistration.getClass().getName()));
            credsRegistration.initialise(this);
        }
        if (this.framework.getConfidentialTextService() == null) {
            throw new FrameworkException("Failed to initialise a Confidential Text Services, unable to continue");
        }
        logger.trace((Object)("Selected Confidential Text Service is " + this.framework.getConfidentialTextService().getClass().getName()));
    }

    void initialiseEventsService(Log logger, BundleContext bundleContext) throws FrameworkException, InvalidSyntaxException {
        logger.trace((Object)"Searching for Events Service providers");
        ServiceReference[] eventServiceReference = bundleContext.getAllServiceReferences(IEventsServiceRegistration.class.getName(), null);
        if (eventServiceReference == null || eventServiceReference.length == 0) {
            throw new FrameworkException("No Events Services have been found");
        }
        for (ServiceReference eventsReference : eventServiceReference) {
            IEventsServiceRegistration eventsRegistration = (IEventsServiceRegistration)bundleContext.getService(eventsReference);
            logger.trace((Object)("Found Events Services Provider " + eventsRegistration.getClass().getName()));
            eventsRegistration.initialise(this);
        }
        if (this.framework.getEventsService() != null) {
            logger.trace((Object)("Selected Events Service is " + this.framework.getEventsService().getClass().getName()));
        }
    }
}

