/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import com.google.gson.JsonArray;
import dev.galasa.framework.RunImpl;
import dev.galasa.framework.beans.Property;
import dev.galasa.framework.beans.SubmitRunRequest;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.utils.GalasaGson;
import dev.galasa.framework.spi.utils.GalasaGsonBuilder;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrameworkRuns
implements IFrameworkRuns {
    private static final Log logger = LogFactory.getLog(FrameworkRuns.class);
    private final Pattern runPattern = Pattern.compile("^\\Qrun.\\E(\\w+)\\Q.\\E.*$");
    private final IFramework framework;
    private final IDynamicStatusStoreService dss;
    private final IConfigurationPropertyStoreService cps;
    private final String NO_GROUP = "none";
    private final String NO_BUNDLE = "none";
    private final String NO_RUNTYPE = "UNKNOWN";
    private final String RUN_PREFIX = "run.";
    private final GalasaGson gson = new GalasaGson();

    public FrameworkRuns(IFramework framework) throws FrameworkException {
        this.framework = framework;
        this.dss = framework.getDynamicStatusStoreService("framework");
        this.cps = framework.getConfigurationPropertyService("framework");
        this.gson.setGsonBuilder(new GalasaGsonBuilder(false));
    }

    @Override
    public List<IRun> getActiveRuns() throws FrameworkException {
        List<IRun> runs = this.getAllRuns();
        Iterator<IRun> iruns = runs.iterator();
        while (iruns.hasNext()) {
            IRun run = iruns.next();
            if (run.getHeartbeat() != null || "allocated".equals(run.getStatus()) || run.isSharedEnvironment()) continue;
            iruns.remove();
        }
        return runs;
    }

    @Override
    @NotNull
    public List<IRun> getQueuedRuns() throws FrameworkException {
        List<IRun> runs = this.getAllRuns();
        Iterator<IRun> iruns = runs.iterator();
        while (iruns.hasNext()) {
            IRun run = iruns.next();
            if ("queued".equals(run.getStatus())) continue;
            iruns.remove();
        }
        return runs;
    }

    @Override
    public List<IRun> getAllRuns() throws FrameworkException {
        HashMap<String, RunImpl> runs = new HashMap<String, RunImpl>();
        logger.trace((Object)"Fetching all runs from DSS");
        Map<String, String> runProperties = this.dss.getPrefix("run.");
        logger.trace((Object)"Fetched all runs from DSS");
        for (String key : runProperties.keySet()) {
            String runName;
            Matcher matcher = this.runPattern.matcher(key);
            if (!matcher.find() || runs.containsKey(runName = matcher.group(1))) continue;
            runs.put(runName, new RunImpl(runName, this.dss));
        }
        LinkedList<IRun> returnRuns = new LinkedList<IRun>(runs.values());
        return returnRuns;
    }

    @Override
    public List<IRun> getAllGroupedRuns(@NotNull String groupName) throws FrameworkException {
        List<IRun> allRuns = this.getAllRuns();
        LinkedList<IRun> groupedRuns = new LinkedList<IRun>();
        for (IRun run : allRuns) {
            if (!groupName.equals(run.getGroup())) continue;
            groupedRuns.add(run);
        }
        return groupedRuns;
    }

    @Override
    @NotNull
    public Set<String> getActiveRunNames() throws FrameworkException {
        List<IRun> runs = this.getActiveRuns();
        HashSet<String> runNames = new HashSet<String>();
        for (IRun run : runs) {
            runNames.add(run.getName());
        }
        return runNames;
    }

    @NotNull
    private IRun submitRun(SubmitRunRequest runRequest) throws FrameworkException {
        IRun run = null;
        this.setRunRequestDefaultsIfNotSet(runRequest);
        if (runRequest.getSharedEnvironmentPhase() != null) {
            run = this.submitSharedEnvironmentRun(runRequest);
        } else {
            try {
                String runName = this.assignNewRunName(runRequest);
                run = new RunImpl(runName, this.dss);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new FrameworkException("Interrupted", (Throwable)e);
            }
            catch (Exception e) {
                throw new FrameworkException("Problem submitting job", (Throwable)e);
            }
        }
        return run;
    }

    @Override
    @NotNull.List(value={@NotNull, @NotNull})
    public @NotNull.List(value={@NotNull, @NotNull}) IRun submitRun(String runType, String requestor, String bundleName, @NotNull String testName, String groupName, String mavenRepository, String obr, String stream, boolean local, boolean trace, Properties overrides, IFrameworkRuns.SharedEnvironmentPhase sharedEnvironmentPhase, String sharedEnvironmentRunName, String language) throws FrameworkException {
        SubmitRunRequest runRequest = new SubmitRunRequest(runType, requestor, bundleName, testName, groupName, mavenRepository, obr, stream, local, trace, overrides, sharedEnvironmentPhase, sharedEnvironmentRunName, language);
        return this.submitRun(runRequest);
    }

    private boolean storeRun(String runName, SubmitRunRequest runRequest) throws DynamicStatusStoreException {
        String bundleName = runRequest.getBundleName();
        String testName = runRequest.getTestName();
        String bundleTest = runRequest.getBundleTest();
        String gherkinTest = runRequest.getGherkinTest();
        String runType = runRequest.getRunType();
        String mavenRepository = runRequest.getMavenRepository();
        String obr = runRequest.getObr();
        String stream = runRequest.getStream();
        String groupName = runRequest.getGroupName();
        String requestor = runRequest.getRequestor();
        IFrameworkRuns.SharedEnvironmentPhase sharedEnvironmentPhase = runRequest.getSharedEnvironmentPhase();
        Properties overrides = runRequest.getOverrides();
        boolean local = runRequest.isLocalRun();
        boolean trace = runRequest.isTraceEnabled();
        String runPropertyPrefix = "run." + runName;
        HashMap<String, String> otherRunProperties = new HashMap<String, String>();
        otherRunProperties.put(runPropertyPrefix + ".status", "queued");
        otherRunProperties.put(runPropertyPrefix + ".queued", Instant.now().toString());
        otherRunProperties.put(runPropertyPrefix + ".testbundle", bundleName);
        otherRunProperties.put(runPropertyPrefix + ".testclass", testName);
        otherRunProperties.put(runPropertyPrefix + ".request.type", runType);
        otherRunProperties.put(runPropertyPrefix + ".local", Boolean.toString(local));
        if (trace) {
            otherRunProperties.put(runPropertyPrefix + ".trace", "true");
        }
        if (mavenRepository != null) {
            otherRunProperties.put(runPropertyPrefix + ".repository", mavenRepository);
        }
        if (obr != null) {
            otherRunProperties.put(runPropertyPrefix + ".obr", obr);
        }
        if (stream != null) {
            otherRunProperties.put(runPropertyPrefix + ".stream", stream);
        }
        if (groupName != null) {
            otherRunProperties.put(runPropertyPrefix + ".group", groupName);
        } else {
            otherRunProperties.put(runPropertyPrefix + ".group", UUID.randomUUID().toString());
        }
        otherRunProperties.put(runPropertyPrefix + ".requestor", requestor);
        if (sharedEnvironmentPhase != null) {
            otherRunProperties.put(runPropertyPrefix + ".shared.environment", "true");
            overrides.put("framework.run.shared.environment.phase", sharedEnvironmentPhase.toString());
        }
        if (gherkinTest != null) {
            otherRunProperties.put(runPropertyPrefix + ".gherkin", gherkinTest);
        }
        if (!overrides.isEmpty()) {
            JsonArray overridesArray = new JsonArray();
            for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                overridesArray.add(this.gson.toJsonTree(new Property(key, value)));
            }
            otherRunProperties.put(runPropertyPrefix + ".overrides", this.gson.toJson(overridesArray));
        }
        return this.dss.putSwap(runPropertyPrefix + ".test", null, bundleTest, otherRunProperties);
    }

    @Override
    public boolean delete(String runname) throws DynamicStatusStoreException {
        String prefix = "run." + runname + ".";
        Map<String, String> properties = this.dss.getPrefix(prefix);
        if (properties.isEmpty()) {
            return false;
        }
        this.dss.deletePrefix(prefix);
        return true;
    }

    @Override
    public boolean reset(String runname) throws DynamicStatusStoreException {
        String prefix = "run." + runname + ".";
        Map<String, String> properties = this.dss.getPrefix(prefix);
        if (properties.isEmpty()) {
            return false;
        }
        if ("true".equals(properties.get(prefix + "local"))) {
            return false;
        }
        this.dss.delete(prefix + "heartbeat");
        this.dss.put(prefix + "status", "queued");
        return true;
    }

    @Override
    public IRun getRun(String runname) throws DynamicStatusStoreException {
        String prefix = "run." + runname + ".";
        Map<String, String> properties = this.dss.getPrefix(prefix);
        if (properties.isEmpty()) {
            return null;
        }
        return new RunImpl(runname, this.dss);
    }

    private String getRunTypePrefix(String runType) throws ConfigurationPropertyStoreException {
        String typePrefix = AbstractManager.nulled(this.cps.getProperty("request.type." + runType, "prefix", new String[0]));
        if (typePrefix == null) {
            typePrefix = "local".equalsIgnoreCase(runType) ? "L" : "U";
        }
        return typePrefix;
    }

    private int getPrefixMaxNumber(String typePrefix) throws ConfigurationPropertyStoreException {
        int maxNumber = Integer.MAX_VALUE;
        String sMaxNumber = AbstractManager.nulled(this.cps.getProperty("request.prefix", "maximum", typePrefix));
        if (sMaxNumber != null) {
            maxNumber = Integer.parseInt(sMaxNumber);
        }
        return maxNumber;
    }

    private void setDiscardSharedEnvironmentPhaseProperties(IRun run, String sharedEnvironmentRunName, String groupName) throws FrameworkException {
        if (!run.isSharedEnvironment()) {
            throw new FrameworkException("Run " + sharedEnvironmentRunName + " is not a shared environment");
        }
        if (!"UP".equalsIgnoreCase(run.getStatus())) {
            throw new FrameworkException("Shared Environment " + sharedEnvironmentRunName + " is not up and running");
        }
        HashMap<String, String> otherProperties = new HashMap<String, String>();
        String runPropertyPrefix = "run." + sharedEnvironmentRunName;
        otherProperties.put(runPropertyPrefix + ".overrides", "framework.run.shared.environment.phase=" + IFrameworkRuns.SharedEnvironmentPhase.DISCARD.toString());
        if (groupName != null) {
            otherProperties.put(runPropertyPrefix + ".group", groupName);
        }
        if (!this.dss.putSwap(runPropertyPrefix + ".status", "up", "queued", otherProperties)) {
            throw new FrameworkException("Failed to switch Shared Environment " + sharedEnvironmentRunName + " to discard");
        }
    }

    private String assignNewRunName(SubmitRunRequest runRequest) throws FrameworkException, InterruptedException {
        String typePrefix = this.getRunTypePrefix(runRequest.getRunType());
        int maxNumber = this.getPrefixMaxNumber(typePrefix);
        runRequest.setSharedEnvironmentPhase(null);
        String runName = null;
        boolean maxlooped = false;
        while (runName == null) {
            String sNewNumber;
            String pLastused = "request.prefix." + typePrefix + ".lastused";
            String sLatestNumber = this.dss.get(pLastused);
            int latestNumber = 0;
            if (sLatestNumber != null && !sLatestNumber.trim().isEmpty()) {
                latestNumber = Integer.parseInt(sLatestNumber);
            }
            if (++latestNumber > maxNumber) {
                if (maxlooped) {
                    throw new FrameworkException("Not enough request type numbers available, looped twice");
                }
                latestNumber = 1;
                maxlooped = true;
            }
            if (!this.dss.putSwap(pLastused, sLatestNumber, sNewNumber = Integer.toString(latestNumber))) {
                Thread.sleep(this.framework.getRandom().nextInt(200));
                continue;
            }
            String tempRunName = typePrefix + sNewNumber;
            if (!this.storeRun(tempRunName, runRequest)) {
                Thread.sleep(this.framework.getRandom().nextInt(200));
                continue;
            }
            runName = tempRunName;
        }
        return runName;
    }

    private IRun submitSharedEnvironmentRun(SubmitRunRequest runRequest) throws FrameworkException {
        String sharedEnvironmentRunName = runRequest.getSharedEnvironmentRunName();
        IFrameworkRuns.SharedEnvironmentPhase sharedEnvironmentPhase = runRequest.getSharedEnvironmentPhase();
        RunImpl run = new RunImpl(sharedEnvironmentRunName, this.dss);
        if (sharedEnvironmentPhase == IFrameworkRuns.SharedEnvironmentPhase.BUILD && !this.storeRun(sharedEnvironmentRunName, runRequest)) {
            throw new FrameworkException("Unable to submit shared environment run " + sharedEnvironmentRunName + ", is there a duplicate runname?");
        }
        if (sharedEnvironmentPhase == IFrameworkRuns.SharedEnvironmentPhase.DISCARD) {
            this.setDiscardSharedEnvironmentPhaseProperties(run, sharedEnvironmentRunName, runRequest.getGroupName());
        }
        return run;
    }

    private void setRunRequestDefaultsIfNotSet(SubmitRunRequest runRequest) throws FrameworkException {
        String runType;
        this.setRunRequestTestDetails(runRequest);
        if (AbstractManager.nulled(runRequest.getGroupName()) == null) {
            runRequest.setGroupName("none");
        }
        if ((runType = AbstractManager.nulled(runRequest.getRunType())) == null) {
            runType = "UNKNOWN";
        }
        runRequest.setRunType(runType.toUpperCase());
        this.setRunRequestRequestorDefault(runRequest);
        runRequest.setStream(AbstractManager.nulled(runRequest.getStream()));
        if (runRequest.getOverrides() == null) {
            runRequest.setOverrides(new Properties());
        }
        this.formatSharedEnvironmentRunName(runRequest);
    }

    private void setRunRequestTestDetails(SubmitRunRequest runRequest) throws FrameworkException {
        String language = runRequest.getLanguage();
        if (language == null) {
            language = "java";
            runRequest.setLanguage(language);
        }
        if (language.equals("java")) {
            if (runRequest.getBundleName() == null) {
                throw new FrameworkException("Missing bundle name");
            }
            runRequest.setBundleTest(runRequest.getBundleName() + "/" + runRequest.getTestName());
        } else if (language.equals("gherkin")) {
            runRequest.setBundleTest("none");
            runRequest.setGherkinTest(runRequest.getTestName());
            runRequest.setBundleName("none");
        }
    }

    private void setRunRequestRequestorDefault(SubmitRunRequest runRequest) throws FrameworkException {
        String requestor = AbstractManager.nulled(runRequest.getRequestor());
        if (requestor == null) {
            requestor = AbstractManager.nulled(this.cps.getProperty("run", "requestor", new String[0]));
            if (requestor == null) {
                requestor = "unknown";
            }
            runRequest.setRequestor(requestor);
        }
    }

    private void formatSharedEnvironmentRunName(SubmitRunRequest runRequest) throws FrameworkException {
        IFrameworkRuns.SharedEnvironmentPhase sharedEnvironmentPhase = runRequest.getSharedEnvironmentPhase();
        if (sharedEnvironmentPhase != null) {
            String sharedEnvironmentRunName = runRequest.getSharedEnvironmentRunName();
            if (sharedEnvironmentRunName == null || sharedEnvironmentRunName.trim().isEmpty()) {
                throw new FrameworkException("Missing run name for shared environment");
            }
            runRequest.setSharedEnvironmentRunName(sharedEnvironmentRunName.trim().toUpperCase());
        }
    }
}

