/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Dictionary;
import org.osgi.framework.FrameworkUtil;

public class FrameworkVersion {
    public static String getBundleVersion() {
        String bundleVersion;
        String version = "UNKNOWN";
        Dictionary headers = FrameworkUtil.getBundle(FrameworkVersion.class).getHeaders();
        if (headers != null && (bundleVersion = (String)headers.get("Bundle-Version")) != null) {
            version = bundleVersion;
        }
        return version;
    }

    public static String getBundleBuild() {
        String bndLastModified;
        String build = "UNKNOWN";
        Dictionary headers = FrameworkUtil.getBundle(FrameworkVersion.class).getHeaders();
        if (headers != null && (bndLastModified = (String)headers.get("Bnd-LastModified")) != null) {
            Instant time = Instant.ofEpochMilli(Long.parseLong(bndLastModified));
            ZonedDateTime zdt = ZonedDateTime.ofInstant(time, ZoneId.systemDefault());
            build = zdt.format(DateTimeFormatter.RFC_1123_DATE_TIME);
        }
        return build;
    }
}

