/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.BaseTestRunner;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.ITestRunnerDataProvider;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunLifecycleStatus;
import dev.galasa.framework.internal.runner.FelixRepoAdminOBRAdder;
import dev.galasa.framework.internal.runner.MavenRepositoryListBuilder;
import dev.galasa.framework.internal.runner.TestRunnerDataProvider;
import dev.galasa.framework.maven.repository.spi.IMavenRepository;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.FrameworkResourceUnavailableException;
import dev.galasa.framework.spi.IGherkinExecutable;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.framework.spi.language.gherkin.GherkinMethod;
import dev.galasa.framework.spi.language.gherkin.GherkinTest;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={GherkinTestRunner.class})
public class GherkinTestRunner
extends BaseTestRunner {
    private Log logger = LogFactory.getLog(GherkinTestRunner.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected RepositoryAdmin repositoryAdmin;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected IMavenRepository mavenRepository;
    private GherkinTest gherkinTest;

    public void runTest(Properties bootstrapProperties, Properties overrideProperties) throws TestRunException {
        TestRunnerDataProvider data = new TestRunnerDataProvider(bootstrapProperties, overrideProperties);
        this.runTest(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(ITestRunnerDataProvider dataProvider) throws TestRunException {
        super.init(dataProvider);
        this.testStructure = this.createNewTestStructure(this.run);
        this.gherkinTest = new GherkinTest(this.run, this.testStructure, this.fileSystem);
        this.writeTestStructure();
        try {
            String rasRunId = this.ras.calculateRasRunId();
            this.storeRasRunIdInDss(this.dss, rasRunId);
            try {
                String streamName = AbstractManager.nulled(this.run.getStream());
                new MavenRepositoryListBuilder(this.mavenRepository, this.cps).addMavenRepositories(streamName, this.run.getRepository());
                new FelixRepoAdminOBRAdder(this.repositoryAdmin, this.cps).addOBRsToRepoAdmin(streamName, this.run.getOBR());
                this.loadGherkinManagerBundles(this.repositoryAdmin, this.bundleContext);
                this.validateGherkinFeature(this.gherkinTest);
                this.logger.info((Object)("Run test: " + this.gherkinTest.getName()));
                this.heartbeat = this.createBeatingHeart(this.framework);
                this.incrimentMetric(this.dss, this.run);
                this.updateStatus(TestRunLifecycleStatus.STARTED, "started");
            }
            catch (Exception ex) {
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                throw new TestRunException(ex.getMessage(), ex);
            }
            ITestRunManagers managers = null;
            try {
                managers = dataProvider.createTestRunManagers(new GalasaTest(this.gherkinTest));
            }
            catch (TestRunException e) {
                String msg = "Exception Exception caught. " + e.getMessage() + " Shutting down and Re-throwing.";
                this.logger.error((Object)msg);
                throw new TestRunException("Problem initialising the Managers for a test run", e);
            }
            if (!this.gherkinTest.allMethodsRegistered().booleanValue()) {
                this.logStatementsNotRecognisedByAnyManager(this.gherkinTest);
                this.stopHeartbeat();
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                throw new TestRunException("Not all methods in test are registered to a Manager");
            }
            try {
                if (managers.anyReasonTestClassShouldBeIgnored()) {
                    this.stopHeartbeat();
                    this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                    return;
                }
            }
            catch (FrameworkException e) {
                throw new TestRunException("Problem asking Managers for an ignore reason", e);
            }
            try {
                this.generateEnvironment(this.gherkinTest, managers);
            }
            catch (Exception e) {
                this.logger.fatal((Object)"Error within test runner", (Throwable)e);
                this.isRunOK = false;
            }
            this.updateStatus(TestRunLifecycleStatus.ENDING, null);
            managers.endOfTestRun();
            boolean markedWaiting = false;
            if (!this.isResourcesAvailable && !this.run.isLocal()) {
                this.markWaiting(this.framework);
                this.logger.info((Object)"Placing queue on the waiting list");
                markedWaiting = true;
            } else {
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
            }
            this.stopHeartbeat();
            this.saveUsedCPSPropertiesToArtifact(this.framework.getRecordProperties(), this.fileSystem, this.ras);
            this.saveAllOverridesPassedToArtifact(this.overrideProperties, this.fileSystem, this.ras);
            if (!markedWaiting) {
                this.deleteRunProperties(this.framework);
            }
            managers.shutdown();
        }
        finally {
            this.shutdownFramework(this.framework);
        }
    }

    private void logStatementsNotRecognisedByAnyManager(GherkinTest gherkinTest) {
        this.logger.error((Object)"The following Gherkin statements have not been registered to a Manager");
        for (GherkinMethod scenario : gherkinTest.getMethods()) {
            this.logger.info((Object)("    Scenario: " + scenario.getName()));
            for (IGherkinExecutable executable : scenario.getExecutables()) {
                Object owner = executable.getOwner();
                if (owner != null) {
                    this.logger.info((Object)("        OK - " + executable.getKeyword() + " " + executable.getValue()));
                    continue;
                }
                this.logger.error((Object)("        MISSING - " + executable.getKeyword() + " " + executable.getValue()));
            }
        }
    }

    private void generateEnvironment(GherkinTest testObject, ITestRunManagers managers) throws TestRunException {
        if (this.isRunOK) {
            try {
                this.updateStatus(TestRunLifecycleStatus.GENERATING, null);
                this.logger.info((Object)"Starting Provision Generate phase");
                managers.provisionGenerate();
                this.createEnvironment(testObject, managers);
            }
            catch (Exception e) {
                this.logger.error((Object)"Provision Generate failed", (Throwable)e);
                if (e instanceof FrameworkResourceUnavailableException) {
                    this.isResourcesAvailable = false;
                }
                testObject.setResult(Result.envfail(e));
                this.testStructure.setResult(testObject.getResult().getName());
                this.isRunOK = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnvironment(GherkinTest testObject, ITestRunManagers managers) throws TestRunException {
        if (!this.isRunOK) {
            return;
        }
        try {
            try {
                this.updateStatus(TestRunLifecycleStatus.BUILDING, null);
                this.logger.info((Object)"Starting Provision Build phase");
                managers.provisionBuild();
            }
            catch (FrameworkException e) {
                this.isRunOK = false;
                this.logger.error((Object)"Provision build failed", (Throwable)e);
                if (e instanceof FrameworkResourceUnavailableException) {
                    this.isResourcesAvailable = false;
                }
                testObject.setResult(Result.envfail(e));
                this.testStructure.setResult(testObject.getResult().getName());
                this.discardEnvironment(managers);
                return;
            }
            this.runEnvironment(testObject, managers);
        }
        finally {
            this.discardEnvironment(managers);
        }
    }

    private void discardEnvironment(ITestRunManagers managers) {
        this.logger.info((Object)"Starting Provision Discard phase");
        managers.provisionDiscard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEnvironment(GherkinTest testObject, ITestRunManagers managers) throws TestRunException {
        if (this.isRunOK) {
            try {
                try {
                    this.updateStatus(TestRunLifecycleStatus.PROVSTART, null);
                    this.logger.info((Object)"Starting Provision Start phase");
                    managers.provisionStart();
                }
                catch (FrameworkException e) {
                    this.isRunOK = false;
                    this.logger.error((Object)"Provision start failed", (Throwable)e);
                    if (e instanceof FrameworkResourceUnavailableException) {
                        this.isResourcesAvailable = false;
                    }
                    testObject.setResult(Result.envfail(e));
                    this.testStructure.setResult(testObject.getResult().getName());
                    this.stopEnvironment(managers);
                    return;
                }
                this.runGherkinTest(testObject, managers);
            }
            finally {
                this.stopEnvironment(managers);
            }
        }
    }

    private void stopEnvironment(ITestRunManagers managers) {
        this.logger.info((Object)"Starting Provision Stop phase");
        managers.provisionStop();
    }

    private void runGherkinTest(GherkinTest testObject, ITestRunManagers managers) throws TestRunException {
        if (!this.isRunOK) {
            return;
        }
        this.updateStatus(TestRunLifecycleStatus.RUNNING, null);
        try {
            this.logger.info((Object)"Running the test class");
            testObject.runTestMethods(managers);
        }
        finally {
            this.updateStatus(TestRunLifecycleStatus.RUNDONE, null);
        }
    }

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    private void loadGherkinManagerBundles(RepositoryAdmin repositoryAdmin, BundleContext bundleContext) throws TestRunException {
        try {
            this.bundleManager.loadAllGherkinManagerBundles(repositoryAdmin, bundleContext);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to load the manager bundles", (Throwable)e);
            throw new TestRunException("Unable to load the manager bundles", e);
        }
    }

    private void validateGherkinFeature(GherkinTest gherkinTest) throws TestRunException {
        if (gherkinTest.getName() == null || gherkinTest.getMethods().size() == 0) {
            throw new TestRunException("Feature file is invalid at URI: " + this.run.getGherkin());
        }
    }
}

