/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class ManagerServiceListener
implements ServiceListener {
    private static final String UNKNOWN = "UNKNOWN";
    private static final Log logger = LogFactory.getLog(ManagerServiceListener.class);

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            this.reportBundleVersion(event.getServiceReference().getBundle());
        }
    }

    private void reportBundleVersion(Bundle bundle) {
        logger.trace((Object)("Manager started : " + this.getBundleName(bundle)));
        logger.trace((Object)("        version : " + bundle.getVersion()));
        logger.trace((Object)("          build : " + this.getBundleBuild(bundle)));
    }

    public String getBundleName(Bundle bundle) {
        String bundleName;
        String name = UNKNOWN;
        Dictionary headers = bundle.getHeaders();
        if (headers != null && (bundleName = (String)headers.get("Bundle-Name")) != null) {
            name = bundleName;
        }
        return name;
    }

    public String getBundleVersion(Bundle bundle) {
        String bundleName;
        String version = UNKNOWN;
        Dictionary headers = bundle.getHeaders();
        if (headers != null && (bundleName = (String)headers.get("Bundle-Version")) != null) {
            version = bundleName;
        }
        return version;
    }

    public String getBundleBuild(Bundle bundle) {
        String bndLastModified;
        String build = UNKNOWN;
        Dictionary headers = bundle.getHeaders();
        if (headers != null && (bndLastModified = (String)headers.get("Bnd-LastModified")) != null) {
            Instant time = Instant.ofEpochMilli(Long.parseLong(bndLastModified));
            ZonedDateTime zdt = ZonedDateTime.ofInstant(time, ZoneId.systemDefault());
            build = zdt.format(DateTimeFormatter.RFC_1123_DATE_TIME);
        }
        return build;
    }
}

