/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.FrameworkInitialisation;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={SetupEcosystem.class})
public class SetupEcosystem {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String DSS_ENV_VAR = "GALASA_DYNAMICSTATUS_STORE";
    private static final String RAS_ENV_VAR = "GALASA_RESULTARCHIVE_STORE";
    private static final String CREDS_ENV_VAR = "GALASA_CREDENTIALS_STORE";
    private static final String AUTH_ENV_VAR = "GALASA_AUTH_STORE";
    private static final String DSS_CPS_NAME = "dynamicstatus";
    private static final String RAS_CPS_NAME = "resultarchive";
    private static final String CREDS_CPS_NAME = "credentials";
    private static final String AUTH_CPS_NAME = "auth";
    private IFramework framework;

    public void setup(Properties bootstrapProperties, Properties overrideProperties) throws FrameworkException {
        this.logger.info((Object)"Initialising Setup Ecosystem Service");
        FrameworkInitialisation frameworkInitialisation = null;
        try {
            frameworkInitialisation = new FrameworkInitialisation(bootstrapProperties, overrideProperties);
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to initialise the Framework Service", (Throwable)e);
        }
        this.framework = frameworkInitialisation.getFramework();
        IConfigurationPropertyStoreService cps = this.framework.getConfigurationPropertyService("framework");
        this.addStoreToCpsProperties(cps, DSS_CPS_NAME, DSS_ENV_VAR);
        this.addStoreToCpsProperties(cps, RAS_CPS_NAME, RAS_ENV_VAR);
        this.addStoreToCpsProperties(cps, CREDS_CPS_NAME, CREDS_ENV_VAR);
        this.addStoreToCpsProperties(cps, AUTH_CPS_NAME, AUTH_ENV_VAR);
        this.logger.info((Object)"Ending Setup Ecosystem Service");
        frameworkInitialisation.shutdownFramework();
    }

    private void addStoreToCpsProperties(IConfigurationPropertyStoreService cps, String storeName, String storeEnvVar) throws ConfigurationPropertyStoreException {
        String storeUri = System.getenv(storeEnvVar);
        String storeCpsProp = storeName + ".store";
        if (storeUri != null && !storeUri.trim().isEmpty()) {
            storeUri = storeUri.trim();
            cps.setProperty(storeCpsProp, storeUri);
            this.logger.info((Object)("framework." + storeCpsProp + " has been set to: " + storeUri));
        } else {
            this.logger.info((Object)("Not setting framework." + storeCpsProp));
        }
    }
}

