/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.After;
import dev.galasa.AfterClass;
import dev.galasa.Before;
import dev.galasa.BeforeClass;
import dev.galasa.ContinueOnTestFailure;
import dev.galasa.Test;
import dev.galasa.framework.GenericMethodWrapper;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.TestMethodWrapper;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunner;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.teststructure.TestMethod;
import dev.galasa.framework.spi.teststructure.TestStructure;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestClassWrapper {
    private Log logger = LogFactory.getLog(TestClassWrapper.class);
    private final String testBundle;
    private final Class<?> testClass;
    private Object testClassObject;
    private Result result;
    private ArrayList<GenericMethodWrapper> beforeClassMethods = new ArrayList();
    private ArrayList<TestMethodWrapper> testMethods = new ArrayList();
    private ArrayList<GenericMethodWrapper> afterClassMethods = new ArrayList();
    private static final String BEFORE_CLASS_ANNOTATION_TYPE = "L" + BeforeClass.class.getName().replaceAll("\\.", "/") + ";";
    private static final String BEFORE_ANNOTATION_TYPE = "L" + Before.class.getName().replaceAll("\\.", "/") + ";";
    private static final String TEST_ANNOTATION_TYPE = "L" + Test.class.getName().replaceAll("\\.", "/") + ";";
    private static final String AFTER_ANNOTATION_TYPE = "L" + After.class.getName().replaceAll("\\.", "/") + ";";
    private static final String AFTER_CLASS_ANNOTATION_TYPE = "L" + AfterClass.class.getName().replaceAll("\\.", "/") + ";";
    public static final String LOG_STARTING = "Starting";
    public static final String LOG_ENDING = "Ending";
    public static final String LOG_START_LINE = "\n" + StringUtils.repeat((String)"-", (int)23) + " ";
    public static final String LOG_ASTERS = StringUtils.repeat((String)"*", (int)100);
    private final TestStructure testStructure;
    private final boolean continueOnTestFailure;
    private final TestRunner testRunner;

    public TestClassWrapper(TestRunner testRunner, String testBundle, Class<?> testClass, TestStructure testStructure) throws ConfigurationPropertyStoreException {
        this.testRunner = testRunner;
        this.testBundle = testBundle;
        this.testClass = testClass;
        this.testStructure = testStructure;
        IConfigurationPropertyStoreService cps = this.testRunner.getCPS();
        String checkContinue = AbstractManager.nulled(cps.getProperty("continue.on.test", "failure", new String[0]));
        this.continueOnTestFailure = checkContinue != null ? Boolean.parseBoolean(checkContinue) : this.testClass.isAnnotationPresent(ContinueOnTestFailure.class);
    }

    /*
     * WARNING - void declaration
     */
    public void parseTestClass() throws TestRunException {
        ArrayList<GenericMethodWrapper> temporaryBeforeMethods = new ArrayList<GenericMethodWrapper>();
        ArrayList<GenericMethodWrapper> temporaryAfterMethods = new ArrayList<GenericMethodWrapper>();
        ArrayList<Method> temporaryTestMethods = new ArrayList<Method>();
        try {
            void var5_7;
            LinkedList<Object> classListList = new LinkedList<Object>();
            classListList.add(this.testClass);
            Class<?> clazz = this.testClass.getSuperclass();
            while (!var5_7.isAssignableFrom(Object.class)) {
                classListList.add(var5_7);
                Class clazz2 = var5_7.getSuperclass();
            }
            Iterator lit = classListList.descendingIterator();
            while (lit.hasNext()) {
                this.parseMethods((Class)lit.next(), temporaryBeforeMethods, temporaryTestMethods, temporaryAfterMethods);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new TestRunException("Unable to process test class for methods", e);
        }
        for (Method method : temporaryTestMethods) {
            this.testMethods.add(new TestMethodWrapper(method, this.testClass, temporaryBeforeMethods, temporaryAfterMethods));
        }
        this.testStructure.setBundle(this.testBundle);
        this.testStructure.setTestName(this.testClass.getName());
        this.testStructure.setTestShortName(this.testClass.getSimpleName());
        ArrayList<TestMethod> structureMethods = new ArrayList<TestMethod>();
        this.testStructure.setMethods(structureMethods);
        for (GenericMethodWrapper before : this.beforeClassMethods) {
            structureMethods.add(before.getStructure());
        }
        for (TestMethodWrapper testMethod : this.testMethods) {
            structureMethods.add(testMethod.getStructure());
        }
        for (GenericMethodWrapper after : this.afterClassMethods) {
            structureMethods.add(after.getStructure());
        }
        String string = this.testStructure.report(LOG_START_LINE);
        this.logger.trace((Object)("Test Class structure:-" + string));
    }

    public void instantiateTestClass() throws TestRunException {
        try {
            this.testClassObject = this.testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
            throw new TestRunException("Unable to instantiate test class", e);
        }
    }

    public void runTestMethods(@NotNull ITestRunManagers managers, IDynamicStatusStoreService dss, String runName) throws TestRunException {
        this.logger.info((Object)(LOG_STARTING + LOG_START_LINE + LOG_ASTERS + LOG_START_LINE + "*** Start of test class " + this.testClass.getName() + LOG_START_LINE + LOG_ASTERS));
        try {
            managers.startOfTestClass();
        }
        catch (FrameworkException e) {
            throw new TestRunException("Unable to inform managers of start of test class", e);
        }
        for (GenericMethodWrapper genericMethodWrapper : this.beforeClassMethods) {
            genericMethodWrapper.invoke(managers, this.testClassObject, null);
            if (!genericMethodWrapper.fullStop()) continue;
            this.result = Result.failed("BeforeClass method failed");
            break;
        }
        if (this.result == null) {
            try {
                dss.put("run." + runName + ".method.total", Integer.toString(this.testMethods.size()));
                int actualMethod = 0;
                for (TestMethodWrapper testMethod : this.testMethods) {
                    dss.put("run." + runName + ".method.current", Integer.toString(++actualMethod));
                    dss.put("run." + runName + ".method.name", testMethod.getName());
                    testMethod.invoke(managers, this.testClassObject, this.continueOnTestFailure);
                    if (!testMethod.fullStop()) continue;
                    break;
                }
                for (TestMethodWrapper testMethod : this.testMethods) {
                    Result testMethodResult = testMethod.getResult();
                    if (testMethodResult == null || !testMethodResult.isFailed()) continue;
                    this.result = Result.failed("A Test failed");
                    break;
                }
                if (this.result == null) {
                    this.result = Result.passed();
                }
                dss.delete("run." + runName + ".method.name");
                dss.delete("run." + runName + ".method.total");
                dss.delete("run." + runName + ".method.current");
            }
            catch (DynamicStatusStoreException e) {
                throw new TestRunException("Failed to update the run status", e);
            }
        }
        for (GenericMethodWrapper genericMethodWrapper : this.afterClassMethods) {
            genericMethodWrapper.invoke(managers, this.testClassObject, null);
            if (!genericMethodWrapper.fullStop() || this.result != null) continue;
            this.result = Result.failed("AfterClass method failed");
        }
        try {
            Result newResult = managers.endOfTestClass(this.result, null);
            if (newResult != null) {
                this.logger.info((Object)("Result of test run overridden to " + newResult.getName()));
                this.result = newResult;
            }
        }
        catch (FrameworkException e) {
            throw new TestRunException("Problem with end of test class", e);
        }
        this.logger.info((Object)(LOG_ENDING + LOG_START_LINE + LOG_ASTERS + LOG_START_LINE + "*** " + this.result.getName() + " - Test class " + this.testClass.getName() + LOG_START_LINE + LOG_ASTERS));
        this.testStructure.setResult(this.result.getName());
        managers.testClassResult(this.result, null);
        String report = this.testStructure.report(LOG_START_LINE);
        this.logger.trace((Object)("Finishing Test Class structure:-" + report));
    }

    private void parseMethods(Class<?> testClassXXX, List<GenericMethodWrapper> temporaryBeforeMethods, List<Method> temporaryTestMethods, List<GenericMethodWrapper> temporaryAfterMethods) throws NoSuchMethodException, TestRunException {
        org.apache.bcel.classfile.Method[] bcelMethods;
        JavaClass bcelJavaClass;
        try {
            bcelJavaClass = Repository.lookupClass(testClassXXX);
        }
        catch (ClassNotFoundException e) {
            throw new TestRunException(e);
        }
        for (org.apache.bcel.classfile.Method bcelMethod : bcelMethods = bcelJavaClass.getMethods()) {
            Annotation[] annotations;
            if (!this.isTestMethod(bcelMethod)) continue;
            Method method = testClassXXX.getMethod(bcelMethod.getName(), new Class[0]);
            for (Annotation annotation : annotations = method.getAnnotations()) {
                this.storeMethod(method, annotation.annotationType(), temporaryBeforeMethods, temporaryTestMethods, temporaryAfterMethods);
            }
        }
    }

    private boolean isTestMethod(org.apache.bcel.classfile.Method bcelMethod) throws TestRunException {
        if (!bcelMethod.getName().equals("<init>")) {
            AnnotationEntry[] annotationEntries = bcelMethod.getAnnotationEntries();
            int testAnnotations = 0;
            for (AnnotationEntry annotationEntry : annotationEntries) {
                if (!annotationEntry.getAnnotationType().equals(BEFORE_CLASS_ANNOTATION_TYPE) && !annotationEntry.getAnnotationType().equals(BEFORE_ANNOTATION_TYPE) && !annotationEntry.getAnnotationType().equals(TEST_ANNOTATION_TYPE) && !annotationEntry.getAnnotationType().equals(AFTER_ANNOTATION_TYPE) && !annotationEntry.getAnnotationType().equals(AFTER_CLASS_ANNOTATION_TYPE)) continue;
                ++testAnnotations;
                if (!bcelMethod.isPublic()) {
                    throw new TestRunException("Method " + bcelMethod.getName() + " must be public");
                }
                if (bcelMethod.getArgumentTypes().length <= 0) continue;
                throw new TestRunException("Method " + bcelMethod.getName() + " should have no parameters");
            }
            if (testAnnotations == 1) {
                return true;
            }
            if (testAnnotations > 1) {
                throw new TestRunException("Method " + bcelMethod.getName() + " should have a single test annotation");
            }
        }
        return false;
    }

    private void storeMethod(Method method, Class<? extends Annotation> annotationType, List<GenericMethodWrapper> temporaryBeforeMethods, List<Method> temporaryTestMethods, List<GenericMethodWrapper> temporaryAfterMethods) {
        if (annotationType == BeforeClass.class) {
            this.beforeClassMethods.add(new GenericMethodWrapper(method, this.testClass, GenericMethodWrapper.Type.BeforeClass));
        }
        if (annotationType == AfterClass.class) {
            this.afterClassMethods.add(new GenericMethodWrapper(method, this.testClass, GenericMethodWrapper.Type.AfterClass));
        }
        if (annotationType == Before.class) {
            temporaryBeforeMethods.add(new GenericMethodWrapper(method, this.testClass, GenericMethodWrapper.Type.Before));
        }
        if (annotationType == After.class) {
            temporaryAfterMethods.add(new GenericMethodWrapper(method, this.testClass, GenericMethodWrapper.Type.After));
        }
        if (annotationType == Test.class) {
            temporaryTestMethods.add(method);
        }
    }

    protected void setResult(Result result) {
        this.result = result;
    }

    protected Result getResult() {
        return this.result;
    }
}

