/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.GenericMethodWrapper;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.teststructure.TestMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestMethodWrapper {
    private Log logger = LogFactory.getLog(TestMethodWrapper.class);
    private final List<GenericMethodWrapper> befores = new ArrayList<GenericMethodWrapper>();
    private GenericMethodWrapper testMethod;
    private final List<GenericMethodWrapper> afters = new ArrayList<GenericMethodWrapper>();
    private Result result;
    private boolean fullStop = false;

    protected TestMethodWrapper(Method testMethod, Class<?> testClass, ArrayList<GenericMethodWrapper> beforeMethods, ArrayList<GenericMethodWrapper> afterMethods) {
        this.testMethod = new GenericMethodWrapper(testMethod, testClass, GenericMethodWrapper.Type.Test);
        for (GenericMethodWrapper before : beforeMethods) {
            this.befores.add(before);
        }
        for (GenericMethodWrapper after : afterMethods) {
            this.afters.add(after);
        }
    }

    public void invoke(@NotNull ITestRunManagers managers, Object testClassObject, boolean continueOnTestFailure) throws TestRunException {
        for (GenericMethodWrapper before : this.befores) {
            before.invoke(managers, testClassObject, this.testMethod);
            if (!before.getResult().isFullStop()) continue;
            this.fullStop = true;
            this.result = Result.failed("Before method failed");
            break;
        }
        if (this.result == null) {
            this.testMethod.invoke(managers, testClassObject, null);
            if (this.testMethod.fullStop()) {
                if (continueOnTestFailure) {
                    this.logger.warn((Object)"Test method failed, however, continue on test failure was requested, so carrying on");
                } else {
                    this.fullStop = this.testMethod.fullStop();
                }
            }
            this.result = this.testMethod.getResult();
        }
        Result afterResult = null;
        for (GenericMethodWrapper after : this.afters) {
            after.invoke(managers, testClassObject, this.testMethod);
            if (!after.fullStop()) continue;
            this.fullStop = true;
            if (afterResult != null) continue;
            afterResult = Result.failed("After method failed");
            if (this.result != null && !this.result.isPassed()) continue;
            this.result = afterResult;
        }
    }

    public boolean fullStop() {
        return this.fullStop;
    }

    public Result getResult() {
        return this.result;
    }

    public String getName() {
        return this.testMethod.getName();
    }

    public TestMethod getStructure() {
        TestMethod methodStructure = this.testMethod.getStructure();
        ArrayList<TestMethod> structureBefores = new ArrayList<TestMethod>();
        ArrayList<TestMethod> structureAfters = new ArrayList<TestMethod>();
        methodStructure.setBefores(structureBefores);
        methodStructure.setAfters(structureAfters);
        for (GenericMethodWrapper before : this.befores) {
            structureBefores.add(before.getStructure());
        }
        for (GenericMethodWrapper after : this.afters) {
            structureAfters.add(after.getStructure());
        }
        return methodStructure;
    }
}

