/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResultArchiveStore;
import java.time.Instant;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRunHeartbeat
extends Thread {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final IFramework framework;
    private final IDynamicStatusStoreService dss;
    private final IResultArchiveStore ras;
    private final String key;
    private String lastHeartbeat = null;
    private boolean shutdown = false;

    protected TestRunHeartbeat(@NotNull IFramework framework) throws DynamicStatusStoreException {
        this.framework = framework;
        this.dss = this.framework.getDynamicStatusStoreService("framework");
        this.ras = this.framework.getResultArchiveStore();
        this.key = "run." + framework.getTestRunName() + ".heartbeat";
        this.setHeartbeat();
    }

    private void setHeartbeat() throws DynamicStatusStoreException {
        String newHeartbeat = Instant.now().toString();
        if (!this.dss.putSwap(this.key, this.lastHeartbeat, newHeartbeat)) {
            this.logger.fatal((Object)"The run heartbeat has been updated by something else");
            this.logger.fatal((Object)"Cannot allow provision discard to run as this could affect the other engine");
            System.exit(0);
        }
        this.lastHeartbeat = newHeartbeat;
        this.ras.flush();
    }

    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        long nextHeartbeat = 0L;
        while (!this.shutdown) {
            if (System.currentTimeMillis() >= nextHeartbeat) {
                nextHeartbeat = System.currentTimeMillis() + 20000L;
                try {
                    this.setHeartbeat();
                }
                catch (DynamicStatusStoreException e) {
                    this.logger.error((Object)"Heartbeat failed", (Throwable)e);
                    nextHeartbeat = System.currentTimeMillis() + 2000L;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.shutdown = true;
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

