/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.Framework;
import dev.galasa.framework.spi.IResultArchiveStore;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class TestRunLogCapture
implements Appender {
    private final Framework framework;
    private IResultArchiveStore ras;
    private final ArrayList<String> startupCache = new ArrayList();
    private PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{HH:mm:ss} %p [%t] %c - %m%n").build();
    private Level minimumLevel = Level.ALL;
    private boolean shutdown = false;
    private LifeCycle.State state = LifeCycle.State.STOPPED;

    public TestRunLogCapture(Framework framework) {
        this.framework = framework;
        LoggerContext ctx = (LoggerContext)LogManager.getContext();
        Configuration config = ctx.getConfiguration();
        Appender stdout = config.getAppender("stdout");
        if (stdout != null) {
            this.layout = (PatternLayout)stdout.getLayout();
        }
        this.start();
        config.addAppender((Appender)this);
        config.getRootLogger().addAppender((Appender)this, null, null);
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            loggerConfig.addAppender((Appender)this, null, null);
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void append(LogEvent event) {
        if (this.shutdown) {
            return;
        }
        if (!event.getLevel().isMoreSpecificThan(this.minimumLevel)) {
            return;
        }
        String message = this.layout.toSerializable(event);
        String throwable = null;
        if (event.getThrownProxy() != null) {
            throwable = event.getThrownProxy().getExtendedStackTraceAsString();
        }
        if (this.ras == null) {
            if (this.framework.isInitialised()) {
                this.ras = this.framework.getResultArchiveStore();
            } else {
                this.startupCache.add(message);
                if (throwable != null) {
                    this.startupCache.add(throwable);
                }
                return;
            }
        }
        if (!this.startupCache.isEmpty()) {
            try {
                this.ras.writeLog(this.startupCache);
                this.startupCache.clear();
            }
            catch (ResultArchiveStoreException e) {
                e.printStackTrace();
                this.startupCache.add(message);
                return;
            }
        }
        try {
            this.ras.writeLog(message);
            if (throwable != null) {
                this.ras.writeLog(throwable);
            }
        }
        catch (ResultArchiveStoreException e) {
            e.printStackTrace();
            this.startupCache.add(message);
        }
    }

    public LifeCycle.State getState() {
        return this.state;
    }

    public void initialize() {
        this.state = LifeCycle.State.INITIALIZED;
    }

    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public void start() {
        this.state = LifeCycle.State.STARTED;
    }

    public void stop() {
        this.state = LifeCycle.State.STOPPED;
    }

    public ErrorHandler getHandler() {
        return null;
    }

    public Layout<? extends Serializable> getLayout() {
        return null;
    }

    public String getName() {
        return "galasa-appender";
    }

    public boolean ignoreExceptions() {
        return false;
    }

    public void setHandler(ErrorHandler handler) {
    }
}

