/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.ManagerException;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.FrameworkResourceUnavailableException;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.GalasaMethod;
import dev.galasa.framework.spi.language.GalasaTest;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestRunManagers
implements ITestRunManagers {
    private final List<IManager> activeManagers = new ArrayList<IManager>();
    private final List<IManager> activeManagersReversed = new ArrayList<IManager>();
    private final Log logger = LogFactory.getLog(TestRunManagers.class);
    private final IFramework framework;
    private final BundleContext bundleContext;
    private final RepositoryAdmin repositoryAdmin;

    public TestRunManagers(IFramework framework, GalasaTest galasaTest) throws FrameworkException {
        this.framework = framework;
        this.bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = this.bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        this.repositoryAdmin = (RepositoryAdmin)this.bundleContext.getService(serviceReference);
        List<IManager> allManagers = this.locateManagers();
        this.requestExtraBundlesFromManager(allManagers, allManagers);
        this.buildActiveManagers(allManagers, galasaTest);
        this.logger.debug((Object)"The following Managers are active:-");
        this.reportManagers(true);
        this.calculateProvisioningDependencies();
        this.logger.debug((Object)"The following Managers are sorted in provisioning order:-");
        this.reportManagers(false);
    }

    private void calculateProvisioningDependencies() throws FrameworkException {
        ArrayList<IManager> sortedManagers = new ArrayList<IManager>(this.activeManagers);
        for (int i = 0; i < sortedManagers.size() - 1; ++i) {
            boolean switched = true;
            int limit = sortedManagers.size() - i + 1;
            block1: while (switched && limit > 0) {
                switched = false;
                --limit;
                IManager testingManager = sortedManagers.get(i);
                for (int j = i + 1; j < sortedManagers.size(); ++j) {
                    IManager checkManager = sortedManagers.get(j);
                    if (!testingManager.areYouProvisionalDependentOn(checkManager)) continue;
                    sortedManagers.set(i, checkManager);
                    sortedManagers.set(j, testingManager);
                    switched = true;
                    continue block1;
                }
            }
        }
        boolean failed = false;
        for (int i = 0; i < sortedManagers.size(); ++i) {
            IManager checkManager;
            int j;
            IManager testingManager = sortedManagers.get(i);
            for (j = 0; j < i; ++j) {
                checkManager = sortedManagers.get(j);
                if (!checkManager.areYouProvisionalDependentOn(testingManager)) continue;
                failed = true;
                break;
            }
            if (failed) break;
            for (j = sortedManagers.size() - 1; i < j; --j) {
                checkManager = sortedManagers.get(j);
                if (!testingManager.areYouProvisionalDependentOn(checkManager)) continue;
                failed = true;
                break;
            }
            if (failed) break;
        }
        if (failed) {
            this.logger.fatal((Object)"The Managers were unable to be sorted into provisioning order");
            this.logger.fatal((Object)"The resulting order was:-");
            for (IManager manager : sortedManagers) {
                this.logger.fatal((Object)("   " + manager.getClass().getName()));
            }
            throw new FrameworkException("Unable to sort managers into order for provisioning");
        }
        this.activeManagers.clear();
        this.activeManagers.addAll(sortedManagers);
        this.activeManagersReversed.addAll(this.activeManagers);
        Collections.reverse(this.activeManagersReversed);
    }

    private void reportManagers(boolean printVersions) {
        for (IManager manager : this.activeManagers) {
            this.logger.debug((Object)("   " + manager.getClass().getName()));
        }
    }

    private void buildActiveManagers(List<IManager> allManagers, GalasaTest galasaTest) throws FrameworkException {
        for (IManager manager : allManagers) {
            try {
                manager.initialise(this.framework, allManagers, this.activeManagers, galasaTest);
            }
            catch (ManagerException e) {
                throw new FrameworkException("Unable to initialise Manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    private void requestExtraBundlesFromManager(List<IManager> managersToCheck, List<IManager> allManagers) throws FrameworkException {
        ArrayList<String> extraBundles = new ArrayList<String>();
        for (IManager manager : managersToCheck) {
            List<String> newExtraBundles;
            try {
                newExtraBundles = manager.extraBundles(this.framework);
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem requesting extra bundles from managers", (Throwable)e);
            }
            if (newExtraBundles == null) continue;
            for (String extraBundle : newExtraBundles) {
                if (extraBundles.contains(extraBundle) || this.isBundleActive(extraBundle)) continue;
                extraBundles.add(extraBundle);
            }
        }
        if (extraBundles.isEmpty()) {
            return;
        }
        for (String extraBundle : extraBundles) {
            this.loadBundle(extraBundle);
        }
        List<IManager> newManagers = this.locateManagers();
        Iterator<IManager> it = newManagers.iterator();
        while (it.hasNext()) {
            IManager nextManager = it.next();
            if (!allManagers.contains(nextManager)) continue;
            it.remove();
        }
        if (newManagers.isEmpty()) {
            return;
        }
        allManagers.addAll(newManagers);
        this.requestExtraBundlesFromManager(newManagers, allManagers);
    }

    private List<IManager> locateManagers() throws FrameworkException {
        ArrayList<IManager> managers = new ArrayList<IManager>();
        try {
            ServiceReference[] managerServiceReference = this.bundleContext.getAllServiceReferences(IManager.class.getName(), null);
            if (managerServiceReference == null || managerServiceReference.length == 0) {
                return managers;
            }
            for (ServiceReference managerReference : managerServiceReference) {
                IManager managerService = (IManager)this.bundleContext.getService(managerReference);
                if (managerService == null) {
                    String componentName = (String)managerReference.getProperty("component.name");
                    if (componentName != null) {
                        throw new FrameworkException("Unable to instantiate Manager " + componentName);
                    }
                    throw new FrameworkException("Unable to instantiate Manager, the name of the manager is unknown");
                }
                managers.add(managerService);
            }
        }
        catch (InvalidSyntaxException e) {
            throw new FrameworkException("Unable to locate Managers", (Throwable)e);
        }
        return managers;
    }

    private void loadBundle(String bundleSymbolicName) throws FrameworkException {
        this.logger.trace((Object)("Installing bundle " + bundleSymbolicName));
        Resolver resolver = this.repositoryAdmin.resolver();
        String filterString = "(symbolicname=" + bundleSymbolicName + ")";
        Resource[] resources = null;
        try {
            resources = this.repositoryAdmin.discoverResources(filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new FrameworkException("Unable to discover repoistory resources", (Throwable)e);
        }
        try {
            if (resources.length == 0) {
                throw new FrameworkException("Unable to locate bundle \"" + bundleSymbolicName + "\" in OBR repository");
            }
            for (Resource resource : resources) {
                this.addResource(bundleSymbolicName, resolver, resource);
            }
        }
        catch (FrameworkException e) {
            throw new FrameworkException("Unable to install bundle \"" + bundleSymbolicName + "\" from OBR repository", (Throwable)e);
        }
    }

    private void addResource(String bundleSymbolicName, Resolver resolver, Resource resource) throws FrameworkException {
        this.logger.trace((Object)("Resouce: " + resource));
        if (this.isBundleActive(bundleSymbolicName)) {
            this.logger.trace((Object)(resource + " already active"));
            return;
        }
        resolver.add(resource);
        boolean resourceHasReferenceUrl = false;
        if (resource.getURI().startsWith("reference:")) {
            resourceHasReferenceUrl = true;
        }
        if (resolver.resolve()) {
            Resource[] optionalResources;
            Resource[] requiredResources;
            for (Resource requiredResource : requiredResources = resolver.getRequiredResources()) {
                if (requiredResource.getURI().startsWith("reference:")) {
                    resourceHasReferenceUrl = true;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)("  RequiredResource: " + requiredResource.getSymbolicName()));
            }
            for (Resource optionalResource : optionalResources = resolver.getOptionalResources()) {
                if (optionalResource.getURI().startsWith("reference:")) {
                    resourceHasReferenceUrl = true;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)("  OptionalResource: " + optionalResource.getSymbolicName()));
            }
            if (!resourceHasReferenceUrl) {
                resolver.deploy(16);
            } else {
                ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
                try {
                    Resource[] startRequiredResources;
                    for (Resource requiredResource : startRequiredResources = resolver.getRequiredResources()) {
                        bundlesToStart.add(this.bundleContext.installBundle(requiredResource.getURI().toString()));
                    }
                    Resource[] startOptionalResources = resolver.getOptionalResources();
                    for (Resource optionalResource : startOptionalResources) {
                        bundlesToStart.add(this.bundleContext.installBundle(optionalResource.getURI().toString()));
                    }
                    bundlesToStart.add(this.bundleContext.installBundle(resource.getURI().toString()));
                    for (Bundle bundle : bundlesToStart) {
                        bundle.start();
                    }
                }
                catch (Exception e) {
                    throw new FrameworkException("Unable to install bundles outside of resolver", (Throwable)e);
                }
            }
            if (!this.isBundleActive(bundleSymbolicName)) {
                String msg = MessageFormat.format("Bundle ''{0}'' failed to install and activate", bundleSymbolicName);
                throw new FrameworkException(msg);
            }
        } else {
            Reason[] unsatisfiedRequirements;
            this.logger.error((Object)("Unable to resolve " + resource.toString()));
            for (Reason reason : unsatisfiedRequirements = resolver.getUnsatisfiedRequirements()) {
                this.logger.error((Object)("Unsatisfied requirement: " + reason.getRequirement()));
            }
            throw new FrameworkException("Unable to resolve bundle " + bundleSymbolicName);
        }
        this.printBundles();
    }

    private boolean isBundleActive(String bundleSymbolicName) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals(bundleSymbolicName) || bundle.getState() != 32) continue;
            return true;
        }
        return false;
    }

    private void printBundles() {
        if (!this.logger.isTraceEnabled()) {
            return;
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        StringBuilder messageBuffer = new StringBuilder(2048);
        messageBuffer.append("Bundle status:");
        for (Bundle bundle : bundles) {
            Object gitHash;
            block10: {
                gitHash = "";
                try {
                    URL githashUrl = bundle.getEntry("/META-INF/git.hash");
                    if (githashUrl == null) break block10;
                    try (InputStream is = githashUrl.openStream();){
                        gitHash = "-" + IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                catch (Exception githashUrl) {
                    // empty catch block
                }
            }
            String bundleId = String.valueOf(bundle.getBundleId());
            messageBuffer.append("\n").append(String.format("%5s", bundleId)).append("|").append(String.format("%-11s", this.getBundleStateLabel(bundle))).append("|     |").append(bundle.getSymbolicName()).append(" (").append(bundle.getVersion()).append((String)gitHash).append(")");
        }
        this.logger.trace((Object)messageBuffer.toString());
    }

    private String getBundleStateLabel(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 32: {
                return "Active";
            }
        }
        return "<Unknown (" + bundle.getState() + ")>";
    }

    @Override
    public boolean anyReasonTestClassShouldBeIgnored() throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                String reason = manager.anyReasonTestClassShouldBeIgnored();
                if (reason == null) continue;
                this.logger.info((Object)("Ignoring class due to " + reason));
                return true;
            }
            catch (ManagerException e) {
                throw new FrameworkException("Unable to calculate Test Class ignore status", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void provisionGenerate() throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                manager.provisionGenerate();
            }
            catch (ResourceUnavailableException e) {
                throw new FrameworkResourceUnavailableException("Resources unavailable during provision generate", (Throwable)e);
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in provision generate for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void provisionBuild() throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                manager.provisionBuild();
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in provision build for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void provisionStart() throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                manager.provisionStart();
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in provision start for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void provisionStop() {
        for (IManager manager : this.activeManagersReversed) {
            manager.provisionStop();
        }
    }

    @Override
    public void provisionDiscard() {
        for (IManager manager : this.activeManagersReversed) {
            manager.provisionDiscard();
        }
    }

    @Override
    public void startOfTestClass() throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                manager.startOfTestClass();
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in start of test class for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public Result anyReasonTestMethodShouldBeIgnored(@NotNull GalasaMethod galasaMethod) throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                String reason = manager.anyReasonTestMethodShouldBeIgnored(galasaMethod);
                if (reason == null) continue;
                return Result.ignore(reason + " from " + manager.getClass().getName());
            }
            catch (ManagerException e) {
                throw new FrameworkException("Unable to calculate Test Method ignore status", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void fillAnnotatedFields(Object testClassObject) throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                manager.fillAnnotatedFields(testClassObject);
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in fill annotated fields for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void startOfTestMethod(@NotNull GalasaMethod galasaMethod) throws FrameworkException {
        for (IManager manager : this.activeManagers) {
            try {
                manager.startOfTestMethod(galasaMethod);
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in start of test test method for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public Result endOfTestMethod(@NotNull GalasaMethod galasaMethod, @NotNull Result currentResult, Throwable currentException) throws FrameworkException {
        Result newResult = null;
        for (IManager manager : this.activeManagers) {
            try {
                Result managerResult = manager.endOfTestMethod(galasaMethod, currentResult, currentException);
                if (managerResult == null || newResult != null) continue;
                newResult = managerResult;
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in end of test method for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
        return newResult;
    }

    @Override
    public Result endOfTestClass(@NotNull Result result, Throwable currentException) throws FrameworkException {
        Result newResult = null;
        for (IManager manager : this.activeManagers) {
            try {
                Result managerResult = manager.endOfTestClass(result, currentException);
                if (managerResult == null || newResult != null) continue;
                newResult = managerResult;
            }
            catch (ManagerException e) {
                throw new FrameworkException("Problem in end of test class for manager " + manager.getClass().getName(), (Throwable)e);
            }
        }
        return newResult;
    }

    @Override
    public void testClassResult(@NotNull Result finalResult, Throwable finalException) {
        for (IManager manager : this.activeManagers) {
            try {
                manager.testClassResult(finalResult.getName(), finalException);
            }
            catch (ManagerException e) {
                this.logger.warn((Object)("Problem in test class result for manager " + manager.getClass().getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void endOfTestRun() {
        for (IManager manager : this.activeManagers) {
            manager.endOfTestRun();
        }
    }

    @Override
    public void shutdown() {
        for (IManager manager : this.activeManagersReversed) {
            manager.shutdown();
        }
    }

    @Override
    public List<IManager> getActiveManagers() {
        return this.activeManagers;
    }
}

