/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.BaseTestRunner;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.ITestRunnerDataProvider;
import dev.galasa.framework.TestClassWrapper;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunLifecycleStatus;
import dev.galasa.framework.internal.runner.FelixRepoAdminOBRAdder;
import dev.galasa.framework.internal.runner.MavenRepositoryListBuilder;
import dev.galasa.framework.internal.runner.RunType;
import dev.galasa.framework.internal.runner.RunTypeDetails;
import dev.galasa.framework.internal.runner.TestRunnerDataProvider;
import dev.galasa.framework.maven.repository.spi.IMavenRepository;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.FrameworkResourceUnavailableException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.GalasaTest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(service={TestRunner.class})
public class TestRunner
extends BaseTestRunner {
    private Log logger = LogFactory.getLog(TestRunner.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected RepositoryAdmin repositoryAdmin;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected IMavenRepository mavenRepository;
    private RunType runType;

    public void runTest(Properties bootstrapProperties, Properties overrideProperties) throws TestRunException {
        TestRunnerDataProvider data = new TestRunnerDataProvider(bootstrapProperties, overrideProperties);
        this.runTest(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(ITestRunnerDataProvider dataProvider) throws TestRunException {
        super.init(dataProvider);
        String testBundleName = this.run.getTestBundleName();
        String testClassName = this.run.getTestClassName();
        this.testStructure = this.createNewTestStructure(this.run);
        this.writeTestStructure();
        try {
            TestClassWrapper testClassWrapper;
            Class<?> testClass;
            String rasRunId = this.ras.calculateRasRunId();
            this.storeRasRunIdInDss(this.dss, rasRunId);
            try {
                String streamName = AbstractManager.nulled(this.run.getStream());
                new MavenRepositoryListBuilder(this.mavenRepository, this.cps).addMavenRepositories(streamName, this.run.getRepository());
                new FelixRepoAdminOBRAdder(this.repositoryAdmin, this.cps).addOBRsToRepoAdmin(streamName, this.run.getOBR());
                this.loadTestBundle(this.repositoryAdmin, this.bundleContext, testBundleName);
                testClass = this.getTestClass(this.bundleContext, testBundleName, testClassName);
            }
            catch (Exception ex) {
                this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                throw new TestRunException(ex.getMessage(), ex);
            }
            RunTypeDetails runTypeDetails = new RunTypeDetails(dataProvider.getAnnotationExtractor(), testClass, testBundleName, testClassName, this.framework);
            this.runType = runTypeDetails.getDetectedRunType();
            this.logger.debug((Object)("Test runType is " + this.runType.toString()));
            if (this.runType == RunType.TEST) {
                this.heartbeat = this.createBeatingHeart(this.framework);
                this.incrimentMetric(this.dss, this.run);
            } else if (this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
                int expireHours = runTypeDetails.getSharedEnvironmentExpireAfterHours();
                Instant expire = Instant.now().plus((long)expireHours, ChronoUnit.HOURS);
                try {
                    this.dss.put("run." + this.run.getName() + ".shared.environment.expire", expire.toString());
                }
                catch (DynamicStatusStoreException e) {
                    String msg = "DynamicStatusStoreException Exception caught. " + e.getMessage() + " Shutting down and Re-throwing.";
                    this.logger.error((Object)msg);
                    this.deleteRunProperties(this.framework);
                    throw new TestRunException("Unable to set the shared environment expire time", e);
                }
            }
            this.logger.debug((Object)"state changing to started.");
            this.updateStatus(TestRunLifecycleStatus.STARTED, "started");
            if (!this.bundleManager.isBundleActive(this.bundleContext, "dev.galasa.core.manager")) {
                try {
                    this.bundleManager.loadBundle(this.repositoryAdmin, this.bundleContext, "dev.galasa.core.manager");
                }
                catch (FrameworkException e) {
                    this.logger.warn((Object)"Tried to load the Core Manager bundle, but failed, test can continue without it", (Throwable)e);
                }
            }
            this.logger.debug((Object)"Bundle is loaded ok.");
            ITestRunManagers managers = null;
            try {
                GalasaTest galasaTest = new GalasaTest(testClass);
                managers = dataProvider.createTestRunManagers(galasaTest);
            }
            catch (TestRunException e) {
                String msg = "Exception Exception caught. " + e.getMessage() + " Shutting down and Re-throwing.";
                this.logger.error((Object)msg);
                throw new TestRunException("Problem initialising the Managers for a test run", e);
            }
            this.logger.debug((Object)"Test managers ok.");
            try {
                if (managers.anyReasonTestClassShouldBeIgnored()) {
                    this.logger.debug((Object)"managers.anyReasonTestClassShouldBeIgnored() is true. Shutting down.");
                    this.stopHeartbeat();
                    this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                    return;
                }
            }
            catch (FrameworkException e) {
                String msg = "Problem asking Managers for an ignore reason";
                this.logger.error((Object)(msg + " " + e.getMessage()));
                throw new TestRunException(msg, e);
            }
            this.logger.debug((Object)"Test class should not be ignored.");
            try {
                testClassWrapper = new TestClassWrapper(this, testBundleName, testClass, this.testStructure);
            }
            catch (ConfigurationPropertyStoreException e) {
                String msg = "Problem with the CPS when adding a wrapper";
                this.logger.error((Object)(msg + " " + e.getMessage()));
                throw new TestRunException(msg, e);
            }
            this.logger.debug((Object)"Parsing test class...");
            testClassWrapper.parseTestClass();
            this.logger.debug((Object)"Instantiating test class...");
            testClassWrapper.instantiateTestClass();
            if (this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
                this.logger.debug((Object)"Checking active managers to see if they support shared env build...");
                boolean invalidManager = false;
                for (IManager manager : managers.getActiveManagers()) {
                    if (manager.doYouSupportSharedEnvironments()) continue;
                    this.logger.error((Object)("Manager " + manager.getClass().getName() + " does not support Shared Environments"));
                    invalidManager = true;
                }
                if (invalidManager) {
                    this.logger.error((Object)"There are Managers that do not support Shared Environment builds");
                    testClassWrapper.setResult(Result.failed("Invalid Shared Environment build"));
                    this.testStructure.setResult(testClassWrapper.getResult().getName());
                    this.isRunOK = false;
                }
            }
            this.logger.debug((Object)("isRunOK: " + Boolean.toString(this.isRunOK)));
            this.logger.debug((Object)"Generating environment...");
            try {
                this.generateEnvironment(testClassWrapper, managers, this.dss, this.run.getName(), this.isRunOK);
            }
            catch (Exception e) {
                this.logger.fatal((Object)"Error within test runner", (Throwable)e);
                this.isRunOK = false;
            }
            this.logger.debug((Object)("isRunOK: " + Boolean.toString(this.isRunOK) + " runType: " + this.runType.toString()));
            if (!this.isRunOK || this.runType == RunType.TEST || this.runType == RunType.SHARED_ENVIRONMENT_DISCARD) {
                this.logger.debug((Object)("Test did not run OK... or runtype is not " + RunType.SHARED_ENVIRONMENT_BUILD.toString()));
                this.updateStatus(TestRunLifecycleStatus.ENDING, null);
                managers.endOfTestRun();
                boolean markedWaiting = false;
                if (!this.isResourcesAvailable && !this.run.isLocal()) {
                    this.markWaiting(this.framework);
                    this.logger.info((Object)"Placing queue on the waiting list");
                    markedWaiting = true;
                } else {
                    if (this.runType == RunType.SHARED_ENVIRONMENT_DISCARD) {
                        this.testStructure.setResult("Discarded");
                        try {
                            this.dss.deletePrefix("run." + this.run.getName() + ".shared.environment");
                        }
                        catch (DynamicStatusStoreException e) {
                            this.logger.error((Object)"Problem cleaning shared environment properties", (Throwable)e);
                        }
                    }
                    this.updateStatus(TestRunLifecycleStatus.FINISHED, "finished");
                }
                this.logger.debug((Object)"Stopping heartbeat...");
                this.stopHeartbeat();
                this.saveUsedCPSPropertiesToArtifact(this.framework.getRecordProperties(), this.fileSystem, this.ras);
                this.saveAllOverridesPassedToArtifact(this.overrideProperties, this.fileSystem, this.ras);
                if (!markedWaiting) {
                    this.deleteRunProperties(this.framework);
                }
            } else if (this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
                this.saveUsedCPSPropertiesToArtifact(this.framework.getRecordProperties(), this.fileSystem, this.ras);
                this.saveAllOverridesPassedToArtifact(this.overrideProperties, this.fileSystem, this.ras);
                this.updateStatus(TestRunLifecycleStatus.UP, "built");
            } else {
                this.logger.error((Object)"Unrecognised end condition");
            }
            this.logger.debug((Object)"Cleaning up managers...");
            managers.shutdown();
        }
        finally {
            this.logger.debug((Object)"Cleaning up framework...");
            this.shutdownFramework(this.framework);
        }
    }

    private void generateEnvironment(TestClassWrapper testClassWrapper, ITestRunManagers managers, IDynamicStatusStoreService dss, String runName, boolean isRunOK) throws TestRunException {
        if (isRunOK) {
            try {
                this.updateStatus(TestRunLifecycleStatus.GENERATING, null);
                this.logger.info((Object)"Starting Provision Generate phase");
                managers.provisionGenerate();
                this.createEnvironment(testClassWrapper, managers, dss, runName, isRunOK);
            }
            catch (Exception e) {
                this.logger.error((Object)"Provision Generate failed", (Throwable)e);
                if (e instanceof FrameworkResourceUnavailableException) {
                    this.isResourcesAvailable = false;
                }
                testClassWrapper.setResult(Result.envfail(e));
                if (this.isResourcesAvailable) {
                    managers.testClassResult(testClassWrapper.getResult(), e);
                }
                this.testStructure.setResult(testClassWrapper.getResult().getName());
                isRunOK = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnvironment(TestClassWrapper testClassWrapper, ITestRunManagers managers, IDynamicStatusStoreService dss, String runName, boolean isRunOK) throws TestRunException {
        if (isRunOK) {
            try {
                if (this.runType == RunType.TEST || this.runType == RunType.SHARED_ENVIRONMENT_BUILD) {
                    try {
                        this.updateStatus(TestRunLifecycleStatus.BUILDING, null);
                        this.logger.info((Object)"Starting Provision Build phase");
                        managers.provisionBuild();
                    }
                    catch (FrameworkException e) {
                        this.isRunOK = false;
                        this.logger.error((Object)"Provision build failed", (Throwable)e);
                        if (e instanceof FrameworkResourceUnavailableException) {
                            this.isResourcesAvailable = false;
                        }
                        testClassWrapper.setResult(Result.envfail(e));
                        if (this.isResourcesAvailable) {
                            managers.testClassResult(testClassWrapper.getResult(), e);
                        }
                        this.testStructure.setResult(testClassWrapper.getResult().getName());
                        this.discardEnvironment(managers);
                        return;
                    }
                }
                this.runEnvironment(testClassWrapper, managers, dss, runName);
            }
            finally {
                this.discardEnvironment(managers);
            }
        }
    }

    private void discardEnvironment(ITestRunManagers managers) {
        if (this.runType != RunType.SHARED_ENVIRONMENT_BUILD) {
            this.logger.info((Object)"Starting Provision Discard phase");
            managers.provisionDiscard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEnvironment(TestClassWrapper testClassWrapper, ITestRunManagers managers, IDynamicStatusStoreService dss, String runName) throws TestRunException {
        if (this.isRunOK) {
            try {
                if (this.runType != RunType.SHARED_ENVIRONMENT_DISCARD) {
                    try {
                        this.updateStatus(TestRunLifecycleStatus.PROVSTART, null);
                        this.logger.info((Object)"Starting Provision Start phase");
                        managers.provisionStart();
                    }
                    catch (FrameworkException e) {
                        this.isRunOK = false;
                        this.logger.error((Object)"Provision start failed", (Throwable)e);
                        if (e instanceof FrameworkResourceUnavailableException) {
                            this.isResourcesAvailable = false;
                        }
                        testClassWrapper.setResult(Result.envfail(e));
                        this.testStructure.setResult(testClassWrapper.getResult().getName());
                        this.stopEnvironment(managers);
                        return;
                    }
                }
                this.runTestClassWrapper(testClassWrapper, managers, dss, runName);
            }
            finally {
                this.stopEnvironment(managers);
            }
        }
    }

    private void stopEnvironment(ITestRunManagers managers) {
        if (this.runType != RunType.SHARED_ENVIRONMENT_BUILD) {
            this.logger.info((Object)"Starting Provision Stop phase");
            managers.provisionStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestClassWrapper(TestClassWrapper testClassWrapper, ITestRunManagers managers, IDynamicStatusStoreService dss, String runName) throws TestRunException {
        if (this.isRunOK && this.runType != RunType.SHARED_ENVIRONMENT_BUILD) {
            this.updateStatus(TestRunLifecycleStatus.RUNNING, null);
            try {
                this.logger.info((Object)"Running the test class");
                testClassWrapper.runTestMethods(managers, dss, runName);
            }
            finally {
                this.updateStatus(TestRunLifecycleStatus.RUNDONE, null);
            }
        }
    }

    private Class<?> getTestClass(BundleContext bundleContext, String testBundleName, String testClassName) throws TestRunException {
        Class testClazz = null;
        Bundle[] bundles = bundleContext.getBundles();
        boolean bundleFound = false;
        for (Bundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(testBundleName)) continue;
            bundleFound = true;
            this.logger.trace((Object)("Found Bundle: " + testBundleName));
            try {
                testClazz = bundle.loadClass(testClassName);
            }
            catch (ClassNotFoundException e) {
                throw new TestRunException("Unable to load test class " + testClassName, e);
            }
            this.logger.trace((Object)("Found test class: " + testClazz.getName()));
            break;
        }
        if (!bundleFound) {
            throw new TestRunException("Unable to find test bundle " + testBundleName);
        }
        return testClazz;
    }

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    private void loadTestBundle(RepositoryAdmin repositoryAdmin, BundleContext bundleContext, String testBundleName) throws TestRunException {
        try {
            this.bundleManager.loadBundle(repositoryAdmin, bundleContext, testBundleName);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to load the test bundle " + testBundleName), (Throwable)e);
            throw new TestRunException("Unable to load the test bundle " + testBundleName, e);
        }
    }
}

