/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework;

import dev.galasa.framework.FrameworkInitialisation;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IFrameworkRuns;
import dev.galasa.framework.spi.IRun;
import java.time.Instant;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ValidateEcosystem.class})
public class ValidateEcosystem {
    private Log logger = LogFactory.getLog(this.getClass());
    private IFramework framework;

    public void setup(Properties bootstrapProperties, Properties overrideProperties) throws FrameworkException {
        boolean runTest;
        this.logger.info((Object)"Initialising Validate Ecosystem Service");
        FrameworkInitialisation frameworkInitialisation = null;
        try {
            frameworkInitialisation = new FrameworkInitialisation(bootstrapProperties, overrideProperties);
        }
        catch (Exception e) {
            throw new FrameworkException("Unable to initialise the Framework Service", (Throwable)e);
        }
        this.framework = frameworkInitialisation.getFramework();
        this.logger.info((Object)"Framework successfully initialised");
        String sRunTest = System.getenv("GALASA_VALIDATE_ENGINE");
        if (sRunTest == null || sRunTest.trim().isEmpty()) {
            sRunTest = "true";
        }
        if (!(runTest = Boolean.parseBoolean(sRunTest))) {
            this.logger.info((Object)"Bypassing engine test");
        } else {
            String status;
            IRun pollRun;
            IFrameworkRuns frameworkRuns = this.framework.getFrameworkRuns();
            IRun testRun = frameworkRuns.submitRun(null, "validateeco", "dev.galasa.core.manager.ivt", "dev.galasa.core.manager.ivt.CoreManagerIVT", null, null, null, null, false, true, null, null, null, null);
            this.logger.info((Object)("Test CoreManagerIVT submitted as run " + testRun.getName()));
            Instant expire = Instant.now().plusSeconds(120L);
            Instant report = Instant.now().plusSeconds(5L);
            while (expire.isAfter(Instant.now())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new FrameworkException("Wait for test run interrupted", (Throwable)e);
                }
                pollRun = frameworkRuns.getRun(testRun.getName());
                status = pollRun.getStatus();
                if (status.equals("finished")) break;
                if (!report.isBefore(Instant.now())) continue;
                this.logger.info((Object)("Test CoreManagerIVT (" + pollRun.getName() + ") has not yet finished"));
                report = Instant.now().plusSeconds(5L);
            }
            if (!(status = (pollRun = frameworkRuns.getRun(testRun.getName())).getStatus()).equals("finished")) {
                this.logger.error((Object)("Test CoreManagerIVT (" + pollRun.getName() + ") did not finish in time, actual status = " + status));
                throw new FrameworkException("Validation failed");
            }
            this.logger.info((Object)("Test CoreManagerIVT (" + pollRun.getName() + ") has finished"));
            String result = pollRun.getResult();
            if (!result.equals("Passed")) {
                this.logger.error((Object)("Test CoreManagerIVT (" + pollRun.getName() + ") did not pass, actual result = " + result));
                throw new FrameworkException("Validation failed");
            }
            this.logger.info((Object)("Test CoreManagerIVT (" + pollRun.getName() + ") has passed"));
        }
        this.logger.info((Object)"Ending Validate Ecosystem Service");
        frameworkInitialisation.shutdownFramework();
    }
}

