/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.auth;

import dev.galasa.framework.spi.auth.AuthStoreException;
import dev.galasa.framework.spi.auth.IAuthStore;
import dev.galasa.framework.spi.auth.IAuthStoreService;
import dev.galasa.framework.spi.auth.IFrontEndClient;
import dev.galasa.framework.spi.auth.IInternalAuthToken;
import dev.galasa.framework.spi.auth.IInternalUser;
import dev.galasa.framework.spi.auth.IUser;
import java.util.List;

public class FrameworkAuthStoreService
implements IAuthStoreService {
    private final IAuthStore authStore;

    public FrameworkAuthStoreService(IAuthStore authStore) {
        this.authStore = authStore;
    }

    @Override
    public List<IInternalAuthToken> getTokens() throws AuthStoreException {
        return this.authStore.getTokens();
    }

    @Override
    public IInternalAuthToken getToken(String tokenId) throws AuthStoreException {
        List<IInternalAuthToken> tokens = this.authStore.getTokens();
        IInternalAuthToken tokenToReturn = null;
        for (IInternalAuthToken token : tokens) {
            if (!token.getTokenId().equals(tokenId)) continue;
            tokenToReturn = token;
            break;
        }
        return tokenToReturn;
    }

    @Override
    public void storeToken(String clientId, String description, IInternalUser owner) throws AuthStoreException {
        this.authStore.storeToken(clientId, description, owner);
    }

    @Override
    public void deleteToken(String tokenId) throws AuthStoreException {
        this.authStore.deleteToken(tokenId);
    }

    @Override
    public List<IInternalAuthToken> getTokensByLoginId(String loginId) throws AuthStoreException {
        return this.authStore.getTokensByLoginId(loginId);
    }

    public List<IUser> getAllUsers() throws AuthStoreException {
        return this.authStore.getAllUsers();
    }

    @Override
    public void createUser(String loginId, String clientName) throws AuthStoreException {
        this.authStore.createUser(loginId, clientName);
    }

    @Override
    public IUser getUserByLoginId(String loginId) throws AuthStoreException {
        return this.authStore.getUserByLoginId(loginId);
    }

    @Override
    public IUser getUser(String userNumber) throws AuthStoreException {
        return this.authStore.getUser(userNumber);
    }

    @Override
    public IUser updateUser(IUser user) throws AuthStoreException {
        return this.authStore.updateUser(user);
    }

    @Override
    public void deleteUser(IUser user) throws AuthStoreException {
        this.authStore.deleteUser(user);
    }

    @Override
    public IFrontEndClient createClient(String clientName) {
        return this.authStore.createClient(clientName);
    }
}

