/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.creds;

import dev.galasa.framework.internal.creds.FileCredentialsStore;
import dev.galasa.framework.spi.IFrameworkInitialisation;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsStoreRegistration;
import java.net.URI;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={ICredentialsStoreRegistration.class})
public class FileCredentialsRegistration
implements ICredentialsStoreRegistration {
    @Override
    public void initialise(@NotNull IFrameworkInitialisation frameworkInitialisation) throws CredentialsException {
        try {
            URI creds = frameworkInitialisation.getCredentialsStoreUri();
            if (creds.getScheme().equals("file")) {
                FileCredentialsStore fcs = new FileCredentialsStore(creds, frameworkInitialisation.getFramework());
                frameworkInitialisation.registerCredentialsStore(fcs);
            }
        }
        catch (Exception e) {
            throw new CredentialsException("Could not initialise Framework Property File CREDs", (Throwable)e);
        }
    }
}

