/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.creds;

import dev.galasa.ICredentials;
import dev.galasa.framework.spi.FrameworkPropertyFile;
import dev.galasa.framework.spi.FrameworkPropertyFileException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.CredentialsToken;
import dev.galasa.framework.spi.creds.CredentialsUsername;
import dev.galasa.framework.spi.creds.CredentialsUsernamePassword;
import dev.galasa.framework.spi.creds.CredentialsUsernameToken;
import dev.galasa.framework.spi.creds.ICredentialsStore;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;

public class FileCredentialsStore
implements ICredentialsStore {
    private final FrameworkPropertyFile fpf;
    private final SecretKeySpec key;
    private final IFramework framework;
    private final IConfigurationPropertyStoreService cpsService;

    public FileCredentialsStore(URI file, IFramework framework) throws CredentialsException {
        try {
            this.framework = framework;
            this.cpsService = this.framework.getConfigurationPropertyService("secure");
            this.fpf = new FrameworkPropertyFile(file);
            String encryptionKey = this.cpsService.getProperty("credentials.file", "encryption.key", new String[0]);
            this.key = encryptionKey != null ? FileCredentialsStore.createKey(encryptionKey) : null;
        }
        catch (Exception e) {
            throw new CredentialsException("Unable to initialise the credentials store", (Throwable)e);
        }
    }

    @Override
    public ICredentials getCredentials(String credentialsId) throws CredentialsException {
        String token = this.fpf.get("secure.credentials." + credentialsId + ".token");
        if (token != null) {
            String username = this.fpf.get("secure.credentials." + credentialsId + ".username");
            if (username != null) {
                return new CredentialsUsernameToken(this.key, username, token);
            }
            return new CredentialsToken(this.key, token);
        }
        String username = this.fpf.get("secure.credentials." + credentialsId + ".username");
        String password = this.fpf.get("secure.credentials." + credentialsId + ".password");
        if (username == null) {
            return null;
        }
        if (password == null) {
            return new CredentialsUsername(this.key, username);
        }
        return new CredentialsUsernamePassword(this.key, username, password);
    }

    private static SecretKeySpec createKey(String secret) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] key = secret.getBytes("UTF-8");
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        key = sha.digest(key);
        return new SecretKeySpec(key, "AES");
    }

    @Override
    public void shutdown() throws CredentialsException {
        try {
            this.fpf.shutdown();
        }
        catch (FrameworkPropertyFileException e) {
            throw new CredentialsException("Problem shutting down the Credentials File", (Throwable)e);
        }
    }

    @Override
    public void setCredentials(String credsId, ICredentials credentials) throws CredentialsException {
    }

    @Override
    public void deleteCredentials(String credsId) throws CredentialsException {
    }

    @Override
    public Map<String, ICredentials> getAllCredentials() throws CredentialsException {
        throw new UnsupportedOperationException("Unimplemented method 'getAllCredentials'");
    }
}

