/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.creds;

import dev.galasa.ICredentials;
import dev.galasa.ICredentialsToken;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.framework.spi.IConfidentialTextService;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.ICredentialsService;
import dev.galasa.framework.spi.creds.ICredentialsStore;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class FrameworkCredentialsService
implements ICredentialsService {
    private final ICredentialsStore credsStore;
    private IConfidentialTextService confTextService;
    private boolean registerConfidentialText;

    public FrameworkCredentialsService(IFramework framework, ICredentialsStore credsStore) throws CredentialsException {
        this.credsStore = credsStore;
        this.confTextService = framework.getConfidentialTextService();
        try {
            IConfigurationPropertyStoreService cpsService = framework.getConfigurationPropertyService("framework");
            this.registerConfidentialText = Boolean.parseBoolean(cpsService.getProperty("credentials", "auto.register.cts", new String[0]));
        }
        catch (Exception e) {
            throw new CredentialsException("Unable to initialise the Credentials Service", (Throwable)e);
        }
    }

    @Override
    public ICredentials getCredentials(@NotNull String credsId) throws CredentialsException {
        ICredentials creds;
        try {
            creds = this.credsStore.getCredentials(credsId);
        }
        catch (CredentialsException e) {
            throw new CredentialsException("Unable to retrieve credentials for id " + credsId, (Throwable)e);
        }
        if (creds == null) {
            return null;
        }
        if (!this.registerConfidentialText) {
            return creds;
        }
        if (creds instanceof ICredentialsToken) {
            ICredentialsToken token = (ICredentialsToken)creds;
            this.confTextService.registerText(new String(token.getToken()), "Token for credentials id " + credsId);
            return creds;
        }
        if (creds instanceof ICredentialsUsernamePassword) {
            ICredentialsUsernamePassword up = (ICredentialsUsernamePassword)creds;
            this.confTextService.registerText(up.getPassword(), "Token for credentials id " + credsId);
            return creds;
        }
        return creds;
    }

    @Override
    public void setCredentials(String credentialsId, ICredentials credentials) throws CredentialsException {
        this.credsStore.setCredentials(credentialsId, credentials);
    }

    @Override
    public void deleteCredentials(String credentialsId) throws CredentialsException {
        this.credsStore.deleteCredentials(credentialsId);
    }

    @Override
    public Map<String, ICredentials> getAllCredentials() throws CredentialsException {
        return this.credsStore.getAllCredentials();
    }
}

