/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.cts;

import dev.galasa.framework.spi.IConfidentialTextService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrameworkConfidentialTextService
implements IConfidentialTextService {
    private List<ConfidentialText> confidentialTexts = new ArrayList<ConfidentialText>();
    private Log logger = LogFactory.getLog(FrameworkConfidentialTextService.class);

    @Override
    public void registerText(String text, String comment) {
        String number = Integer.toString(this.confidentialTexts.size() + 1);
        StringBuilder builder = new StringBuilder();
        String star = "*";
        builder.append(number);
        while (builder.toString().length() != text.length()) {
            builder.append("*");
            if (builder.toString().length() == text.length()) continue;
            builder.reverse();
            builder.append("*");
            builder.reverse();
        }
        ConfidentialText ct = new ConfidentialText(text, builder.toString(), comment);
        this.confidentialTexts.add(ct);
        this.logger.info((Object)("Confidential text registered as '" + ct.replacementTag + "', with comment " + ct.getComment()));
    }

    @Override
    public String removeConfidentialText(String text) {
        for (ConfidentialText confidentials : this.confidentialTexts) {
            text = text.replaceAll(Matcher.quoteReplacement(confidentials.getText()), confidentials.getTag());
        }
        return text;
    }

    @Override
    public void shutdown() {
    }

    private class ConfidentialText {
        private String text;
        private String replacementTag;
        private String comment;

        public ConfidentialText(String text, String replacementTag, String comment) {
            this.text = text;
            this.replacementTag = replacementTag;
            this.comment = comment;
        }

        public String getText() {
            return this.text;
        }

        public String getTag() {
            return this.replacementTag;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

