/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.dss;

import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreMatchException;
import dev.galasa.framework.spi.FrameworkPropertyFile;
import dev.galasa.framework.spi.FrameworkPropertyFileException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreWatcher;
import dev.galasa.framework.spi.IFrameworkPropertyFileWatcher;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

public class FpfDynamicStatusStore
implements IDynamicStatusStore {
    private FrameworkPropertyFile fpf;

    public FpfDynamicStatusStore(URI file) throws DynamicStatusStoreException {
        try {
            this.fpf = new FrameworkPropertyFile(file);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Failed to create Framework property file", (Throwable)e);
        }
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) throws DynamicStatusStoreException {
        try {
            this.fpf.set(key, value);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to put key/value pair", (Throwable)e);
        }
    }

    @Override
    public void put(@NotNull Map<String, String> keyValues) throws DynamicStatusStoreException {
        try {
            this.fpf.set(keyValues);
        }
        catch (FrameworkPropertyFileException | IOException e) {
            throw new DynamicStatusStoreException("Unable to put map of key/value pairs", (Throwable)e);
        }
    }

    @Override
    public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue) throws DynamicStatusStoreException {
        try {
            return this.fpf.setAtomic(key, oldValue, newValue);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to swap old value for new value with given key", (Throwable)e);
        }
    }

    @Override
    public boolean putSwap(@NotNull String key, String oldValue, @NotNull String newValue, @NotNull Map<String, String> others) throws DynamicStatusStoreException {
        try {
            return this.fpf.setAtomic(key, oldValue, newValue, others);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to swap old value for new value and put map of key/value pairs with given key", (Throwable)e);
        }
    }

    @Override
    @Null
    public String get(@NotNull String key) throws DynamicStatusStoreException {
        return this.fpf.get(key);
    }

    @Override
    @NotNull
    public Map<String, String> getPrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        try {
            return this.fpf.getPrefix(keyPrefix);
        }
        catch (Exception e) {
            throw new DynamicStatusStoreException("Unable to get map of key/value pairs with given key prefix", (Throwable)e);
        }
    }

    @Override
    public void delete(@NotNull String key) throws DynamicStatusStoreException {
        try {
            this.fpf.delete(key);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to delete key/value pair with given key", (Throwable)e);
        }
    }

    @Override
    public void delete(@NotNull Set<String> keys) throws DynamicStatusStoreException {
        try {
            this.fpf.delete(keys);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to delete key/value pairs with given keys", (Throwable)e);
        }
    }

    @Override
    public void deletePrefix(@NotNull String keyPrefix) throws DynamicStatusStoreException {
        try {
            this.fpf.deletePrefix(keyPrefix);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to delete key/value pairs with given key prefix", (Throwable)e);
        }
    }

    @Override
    public void performActions(IDssAction ... actions) throws DynamicStatusStoreException, DynamicStatusStoreMatchException {
        this.fpf.performActions(actions);
    }

    @Override
    public UUID watch(IDynamicStatusStoreWatcher watcher, String key) throws DynamicStatusStoreException {
        try {
            return this.fpf.watch(new PassthroughWatcher(watcher), key);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to set a new watch on key '" + key + "'", (Throwable)e);
        }
    }

    @Override
    public UUID watchPrefix(IDynamicStatusStoreWatcher watcher, String keyPrefix) throws DynamicStatusStoreException {
        try {
            return this.fpf.watchPrefix(new PassthroughWatcher(watcher), keyPrefix);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to set a new watch on keyprefix '" + keyPrefix + "'", (Throwable)e);
        }
    }

    @Override
    public void unwatch(UUID watchId) throws DynamicStatusStoreException {
        try {
            this.fpf.unwatch(watchId);
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Unable to unwatch", (Throwable)e);
        }
    }

    @Override
    public void shutdown() throws DynamicStatusStoreException {
        try {
            this.fpf.shutdown();
        }
        catch (FrameworkPropertyFileException e) {
            throw new DynamicStatusStoreException("Problem shutting down the DSS File", (Throwable)e);
        }
    }

    private static class PassthroughWatcher
    implements IFrameworkPropertyFileWatcher {
        private final IDynamicStatusStoreWatcher watcher;

        private PassthroughWatcher(IDynamicStatusStoreWatcher watcher) {
            this.watcher = watcher;
        }

        @Override
        public void propertyModified(String key, IFrameworkPropertyFileWatcher.Event event, String oldValue, String newValue) {
            this.watcher.propertyModified(key, IDynamicStatusStoreWatcher.Event.valueOf(event.toString()), oldValue, newValue);
        }
    }
}

