/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.dss;

import dev.galasa.framework.internal.dss.FrameworkDynamicResource;
import dev.galasa.framework.internal.dss.FrameworkDynamicRun;
import dev.galasa.framework.internal.dss.FrameworkDynamicStoreKeyAccess;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicResource;
import dev.galasa.framework.spi.IDynamicRun;
import dev.galasa.framework.spi.IDynamicStatusStore;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import java.util.Objects;

public class FrameworkDynamicStatusStoreService
extends FrameworkDynamicStoreKeyAccess
implements IDynamicStatusStoreService {
    private final String namespace;

    public FrameworkDynamicStatusStoreService(IFramework framework, IDynamicStatusStore dssStore, String namespace) {
        super(dssStore, "dss." + namespace + ".", namespace);
        Objects.requireNonNull(namespace);
        this.namespace = namespace;
    }

    @Override
    public IDynamicResource getDynamicResource(String resourceKey) {
        String newPrefix = "dss.framework.resource." + this.namespace + "." + resourceKey + ".";
        return new FrameworkDynamicResource(this.getDssStore(), newPrefix, this.namespace);
    }

    @Override
    public IDynamicRun getDynamicRun() throws DynamicStatusStoreException {
        return new FrameworkDynamicRun();
    }
}

