/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras;

import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResultArchiveStoreDirectoryService;
import dev.galasa.framework.spi.IResultArchiveStoreService;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.teststructure.TestStructure;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class FrameworkMultipleResultArchiveStore
implements IResultArchiveStoreService {
    private final ArrayList<IResultArchiveStoreService> rasServices = new ArrayList();

    public FrameworkMultipleResultArchiveStore(@NotNull IFramework framework, @NotNull IResultArchiveStoreService rasService) throws ResultArchiveStoreException {
        if (framework.getTestRunName() != null) {
            throw new ResultArchiveStoreException("RAS does not yet support multiple stores during test runs");
        }
        this.rasServices.add(rasService);
    }

    public void addResultArchiveStoreService(@NotNull IResultArchiveStoreService resultArchiveStoreService) {
        this.rasServices.add(resultArchiveStoreService);
    }

    @Override
    public void writeLog(@NotNull String message) throws ResultArchiveStoreException {
        for (IResultArchiveStoreService rasService : this.rasServices) {
            rasService.writeLog(message);
        }
    }

    @Override
    public void writeLog(@NotNull List<String> messages) throws ResultArchiveStoreException {
        for (IResultArchiveStoreService rasService : this.rasServices) {
            rasService.writeLog(messages);
        }
    }

    @Override
    public void updateTestStructure(@NotNull TestStructure testStructure) throws ResultArchiveStoreException {
        for (IResultArchiveStoreService rasService : this.rasServices) {
            rasService.updateTestStructure(testStructure);
        }
    }

    @Override
    public Path getStoredArtifactsRoot() {
        return this.rasServices.get(0).getStoredArtifactsRoot();
    }

    @Override
    public void flush() {
        for (IResultArchiveStoreService rasService : this.rasServices) {
            rasService.flush();
        }
    }

    @Override
    public void shutdown() {
        for (IResultArchiveStoreService rasService : this.rasServices) {
            rasService.shutdown();
        }
    }

    @Override
    @NotNull
    public List<IResultArchiveStoreDirectoryService> getDirectoryServices() {
        ArrayList<IResultArchiveStoreDirectoryService> dirs = new ArrayList<IResultArchiveStoreDirectoryService>();
        for (IResultArchiveStoreService rasService : this.rasServices) {
            dirs.addAll(rasService.getDirectoryServices());
        }
        return dirs;
    }

    @Override
    public String calculateRasRunId() {
        if (this.rasServices.size() > 0) {
            return this.rasServices.get(0).calculateRasRunId();
        }
        return null;
    }
}

