/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras.directory;

import dev.galasa.framework.internal.ras.directory.DirectoryRASRunResult;
import dev.galasa.framework.spi.IResultArchiveStoreDirectoryService;
import dev.galasa.framework.spi.IRunResult;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.ras.IRasSearchCriteria;
import dev.galasa.framework.spi.ras.RasRunResultPage;
import dev.galasa.framework.spi.ras.RasSortField;
import dev.galasa.framework.spi.ras.RasTestClass;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.GalasaGson;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectoryRASDirectoryService
implements IResultArchiveStoreDirectoryService {
    public static final String ID_PREFIX = "local-";
    private final Path baseDirectory;
    private final GalasaGson gson;

    protected DirectoryRASDirectoryService(@NotNull Path baseDirectory, GalasaGson gson) {
        this.baseDirectory = baseDirectory;
        this.gson = gson;
    }

    @Override
    @NotNull
    public List<IRunResult> getRuns(IRasSearchCriteria ... searchCriteria) throws ResultArchiveStoreException {
        ArrayList<IRunResult> runs = new ArrayList<IRunResult>();
        List<DirectoryRASRunResult> allRuns = this.getAllRuns();
        boolean matched = true;
        for (DirectoryRASRunResult run : allRuns) {
            matched = true;
            for (IRasSearchCriteria criteria : searchCriteria) {
                if (criteria.criteriaMatched(run.getTestStructure())) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            runs.add(run);
        }
        return runs;
    }

    @Override
    @NotNull
    public RasRunResultPage getRunsPage(int maxResults, RasSortField primarySort, String pageToken, IRasSearchCriteria ... searchCriteria) throws ResultArchiveStoreException {
        return new RasRunResultPage(this.getRuns(searchCriteria), null);
    }

    @Override
    @NotNull
    public String getName() {
        return "Local " + this.baseDirectory.toString();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getRequestors() throws ResultArchiveStoreException {
        HashSet<String> requestors = new HashSet<String>();
        for (DirectoryRASRunResult result : this.getAllRuns()) {
            TestStructure testStructure;
            if (result == null || (testStructure = result.getTestStructure()) == null || testStructure.getTestName() == null) continue;
            requestors.add(testStructure.getRequestor());
        }
        return new ArrayList<String>(requestors);
    }

    @Override
    @NotNull
    public List<RasTestClass> getTests() throws ResultArchiveStoreException {
        HashMap<CallSite, RasTestClass> tests = new HashMap<CallSite, RasTestClass>();
        for (DirectoryRASRunResult result : this.getAllRuns()) {
            String key;
            TestStructure testStructure;
            if (result == null || (testStructure = result.getTestStructure()) == null || testStructure.getTestName() == null || tests.containsKey(key = testStructure.getBundle() + "/" + testStructure.getTestName())) continue;
            tests.put((CallSite)((Object)key), new RasTestClass(testStructure.getTestName(), testStructure.getBundle()));
        }
        return new ArrayList<RasTestClass>(tests.values());
    }

    @Override
    @NotNull
    public List<String> getResultNames() throws ResultArchiveStoreException {
        HashSet<String> results = new HashSet<String>();
        for (DirectoryRASRunResult result : this.getAllRuns()) {
            TestStructure testStructure;
            if (result == null || (testStructure = result.getTestStructure()) == null) continue;
            if (testStructure.getResult() == null) {
                results.add("UNKNOWN");
                continue;
            }
            results.add(testStructure.getResult());
        }
        return new ArrayList<String>(results);
    }

    @NotNull
    protected List<DirectoryRASRunResult> getAllRuns() throws ResultArchiveStoreException {
        try {
            ArrayList<DirectoryRASRunResult> runs = new ArrayList<DirectoryRASRunResult>();
            try (Stream<Path> stream = Files.list(Paths.get(this.baseDirectory.toUri()));){
                stream.forEach(new ConsumeRuns(this.baseDirectory, runs, this.gson));
            }
            return runs;
        }
        catch (Throwable t) {
            throw new ResultArchiveStoreException("Unable to obtain runs", t);
        }
    }

    @Override
    public IRunResult getRunById(@NotNull String runId) throws ResultArchiveStoreException {
        if (!runId.startsWith(ID_PREFIX)) {
            return null;
        }
        try {
            String runSubPath = new String(Base64.getDecoder().decode(runId.substring(ID_PREFIX.length())), StandardCharsets.UTF_8);
            Path runPath = this.baseDirectory.resolve(runSubPath);
            if (!Files.exists(runPath, new LinkOption[0])) {
                return null;
            }
            Path structureFile = runPath.resolve("structure.json");
            if (!Files.exists(structureFile, new LinkOption[0])) {
                return null;
            }
            return new DirectoryRASRunResult(runPath, this.gson, runId);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class ConsumeRuns
    implements Consumer<Path> {
        private final Path base;
        private final List<DirectoryRASRunResult> results;
        private final GalasaGson gson;
        private final Base64.Encoder encoder;
        private final Log logger = LogFactory.getLog(ConsumeRuns.class);

        public ConsumeRuns(Path base, List<DirectoryRASRunResult> results, GalasaGson gson) {
            this.base = base;
            this.results = results;
            this.gson = gson;
            this.encoder = Base64.getEncoder();
        }

        @Override
        public void accept(Path path) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            Path structureFile = path.resolve("structure.json");
            if (Files.exists(structureFile, new LinkOption[0])) {
                try {
                    Path relativePath = this.base.relativize(path);
                    String id = DirectoryRASDirectoryService.ID_PREFIX + this.encoder.encodeToString(relativePath.toString().getBytes(StandardCharsets.UTF_8));
                    this.results.add(new DirectoryRASRunResult(path, this.gson, id));
                }
                catch (Throwable t) {
                    this.logger.trace((Object)("Unable to create a run result from " + structureFile.toString()));
                }
            }
        }
    }
}

