/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras.directory;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import dev.galasa.framework.internal.ras.directory.DirectoryRASFileSystemProvider;
import dev.galasa.framework.spi.IRunResult;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.GalasaGson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class DirectoryRASRunResult
implements IRunResult {
    private final Path runDirectory;
    private final TestStructure testStructure;
    private final DirectoryRASFileSystemProvider fileSystemProvider;
    private final String id;

    protected DirectoryRASRunResult(Path runDirectory, GalasaGson gson, String id) throws JsonSyntaxException, JsonIOException, IOException {
        this.runDirectory = runDirectory;
        this.id = id;
        Path structureFile = this.runDirectory.resolve("structure.json");
        try (InputStreamReader in = new InputStreamReader(Files.newInputStream(structureFile, new OpenOption[0]));){
            this.testStructure = gson.fromJson(in, TestStructure.class);
        }
        this.fileSystemProvider = new DirectoryRASFileSystemProvider(this.runDirectory);
    }

    protected DirectoryRASRunResult() {
        this.testStructure = null;
        this.runDirectory = null;
        this.fileSystemProvider = null;
        this.id = null;
    }

    @Override
    public TestStructure getTestStructure() throws ResultArchiveStoreException {
        return this.testStructure;
    }

    @Override
    public Path getArtifactsRoot() throws ResultArchiveStoreException {
        return this.fileSystemProvider.getActualFileSystem().getPath("/", new String[0]);
    }

    @Override
    public String getLog() throws ResultArchiveStoreException {
        Path runLog = this.runDirectory.resolve("run.log");
        if (Files.exists(runLog, new LinkOption[0])) {
            try {
                return new String(Files.readAllBytes(runLog));
            }
            catch (Exception e) {
                throw new ResultArchiveStoreException("Unable to read the run log at " + runLog.toString(), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public void discard() throws ResultArchiveStoreException {
    }

    @Override
    public String getRunId() {
        return this.id;
    }

    @Override
    public void loadArtifacts() throws ResultArchiveStoreException {
    }
}

