/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.ras.directory;

import dev.galasa.framework.internal.ras.directory.DirectoryRASDirectoryService;
import dev.galasa.framework.internal.ras.directory.DirectoryRASFileSystemProvider;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResultArchiveStoreDirectoryService;
import dev.galasa.framework.spi.IResultArchiveStoreService;
import dev.galasa.framework.spi.ResultArchiveStoreException;
import dev.galasa.framework.spi.teststructure.TestStructure;
import dev.galasa.framework.spi.utils.GalasaGson;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={IResultArchiveStoreService.class})
public class DirectoryResultArchiveStoreService
implements IResultArchiveStoreService {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final IFramework framework;
    private final URI rasUri;
    private final Path baseDirectory;
    private boolean shutdown = false;
    private Path runDirectory;
    private Path testStructureFile;
    private Path runLog;
    private final GalasaGson gson = new GalasaGson();
    private DirectoryRASFileSystemProvider provider;

    public DirectoryResultArchiveStoreService(IFramework framework, URI rasUri) throws ResultArchiveStoreException {
        this.framework = framework;
        this.rasUri = rasUri;
        this.baseDirectory = Paths.get(this.rasUri);
        try {
            Files.createDirectories(this.baseDirectory, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to create the RAS base directory '" + this.baseDirectory + "'", (Throwable)e);
        }
        String runName = this.framework.getTestRunName();
        if (runName == null) {
            return;
        }
        this.setRasRun(runName);
        this.testStructureFile = this.runDirectory.resolve("structure.json");
        this.runLog = this.runDirectory.resolve("run.log");
        try {
            Files.createFile(this.runLog, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ResultArchiveStoreException("Unable to create Run Log", (Throwable)e);
        }
        try {
            this.provider = new DirectoryRASFileSystemProvider(this.runDirectory);
        }
        catch (IOException e) {
            throw new ResultArchiveStoreException("Unable to create the RAS Provider", (Throwable)e);
        }
    }

    private void setRasRun(String runname) throws ResultArchiveStoreException {
        block6: {
            this.runDirectory = this.baseDirectory.resolve(runname);
            try {
                if (!Files.exists(this.runDirectory, new LinkOption[0])) break block6;
                Path movePath = null;
                int i = 2;
                while (true) {
                    if (!Files.exists(movePath = this.runDirectory.resolveSibling(runname + "-" + Integer.toString(i)), new LinkOption[0])) {
                        Files.move(this.runDirectory, movePath, new CopyOption[0]);
                        break;
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new ResultArchiveStoreException("Unable to create the RAS run directory '" + this.runDirectory + "'", (Throwable)e);
            }
        }
        try {
            Files.createDirectories(this.runDirectory, new FileAttribute[0]);
            Files.createDirectories(this.runDirectory.resolve("artifacts"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ResultArchiveStoreException("Unable to create the RAS run directory '" + this.runDirectory + "'", (Throwable)e);
        }
    }

    @Override
    public void writeLog(@NotNull String message) throws ResultArchiveStoreException {
        Objects.requireNonNull(message);
        if (!((String)message).endsWith("\n")) {
            message = (String)message + "\n";
        }
        if (this.framework.getConfidentialTextService() != null) {
            message = this.framework.getConfidentialTextService().removeConfidentialText((String)message);
        }
        try {
            Files.write(this.runLog, ((String)message).getBytes(UTF8), StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to write message to run log", (Throwable)e);
        }
    }

    @Override
    public void writeLog(@NotNull List<String> messages) throws ResultArchiveStoreException {
        Objects.requireNonNull(messages);
        for (String message : messages) {
            try {
                this.writeLog(message);
            }
            catch (Exception e) {
                throw new ResultArchiveStoreException("Unable to write messages to run log", (Throwable)e);
            }
        }
    }

    @Override
    public void updateTestStructure(@NotNull TestStructure testStructure) throws ResultArchiveStoreException {
        try {
            testStructure.normalise();
            String json = this.gson.toJson(testStructure);
            Files.write(this.testStructureFile, json.getBytes(UTF8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new ResultArchiveStoreException("Unable to write the test structure", (Throwable)e);
        }
    }

    @Override
    public Path getStoredArtifactsRoot() {
        return this.provider.getActualFileSystem().getPath("/", new String[0]);
    }

    @Override
    public void flush() {
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    @NotNull
    public List<IResultArchiveStoreDirectoryService> getDirectoryServices() {
        ArrayList<IResultArchiveStoreDirectoryService> dirs = new ArrayList<IResultArchiveStoreDirectoryService>(1);
        dirs.add(new DirectoryRASDirectoryService(this.baseDirectory, this.gson));
        return dirs;
    }

    @Override
    public String calculateRasRunId() {
        String runName = this.framework.getTestRunName();
        if (runName == null) {
            return null;
        }
        String id = "local-" + Base64.getEncoder().encodeToString(this.runDirectory.toString().getBytes(StandardCharsets.UTF_8));
        return id;
    }
}

