/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.runner;

import dev.galasa.framework.TestRunException;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.bundlerepository.RepositoryAdmin;

public class FelixRepoAdminOBRAdder {
    private Log logger = LogFactory.getLog(FelixRepoAdminOBRAdder.class);
    private IConfigurationPropertyStoreService cps;
    private RepositoryAdmin repoAdmin;

    public FelixRepoAdminOBRAdder(RepositoryAdmin repoAdmin, IConfigurationPropertyStoreService cps) {
        this.repoAdmin = repoAdmin;
        this.cps = cps;
    }

    public void addOBRsToRepoAdmin(String streamName, String runOBRLIst) throws TestRunException {
        String testOBR = this.getTestOBRFromStream(streamName);
        testOBR = this.getOverriddenValue(testOBR, runOBRLIst);
        this.addOBRsToRepoAdmin(testOBR, this.repoAdmin);
    }

    private String getTestOBRFromStream(String streamName) throws TestRunException {
        String testOBR = null;
        if (streamName != null) {
            this.logger.debug((Object)("Loading test stream " + streamName));
            try {
                testOBR = this.cps.getProperty("test.stream", "obr", streamName);
            }
            catch (Exception e) {
                throw new TestRunException("Unable to load stream " + streamName + " settings", e);
            }
        }
        return testOBR;
    }

    private void addOBRsToRepoAdmin(String testOBR, RepositoryAdmin repoAdmin) throws TestRunException {
        if (testOBR != null) {
            this.logger.debug((Object)("Loading test obr repository " + testOBR));
            try {
                String[] testOBRs;
                for (String obr : testOBRs = testOBR.split("\\,")) {
                    if ((obr = obr.trim()).isEmpty()) continue;
                    repoAdmin.addRepository(obr);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to load specified OBR " + testOBR), (Throwable)e);
                throw new TestRunException("Unable to load specified OBR " + testOBR, e);
            }
        }
    }

    private String getOverriddenValue(String existingValue, String possibleOverrideValue) {
        String result = existingValue;
        String possibleNulledValue = AbstractManager.nulled(possibleOverrideValue);
        if (possibleNulledValue != null) {
            result = possibleNulledValue;
        }
        return result;
    }
}

