/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.runner;

import dev.galasa.SharedEnvironment;
import dev.galasa.Test;
import dev.galasa.framework.IAnnotationExtractor;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.internal.runner.RunType;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.SharedEnvironmentRunType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunTypeDetails {
    private RunType detectedRunType;
    private int expireAfterHours;
    private Log logger;

    public RunTypeDetails(IAnnotationExtractor annotationExtractor, Class<?> testClass, String testBundleName, String testClassName, IFramework framework) throws TestRunException {
        block13: {
            this.expireAfterHours = 8;
            this.logger = LogFactory.getLog(RunTypeDetails.class);
            this.logger.debug((Object)"Getting test annotations..");
            Test testAnnotation = annotationExtractor.getAnnotation(testClass, Test.class);
            this.logger.debug((Object)"Test annotations.. got");
            SharedEnvironment sharedEnvironmentAnnotation = annotationExtractor.getAnnotation(testClass, SharedEnvironment.class);
            this.logger.debug((Object)"Checking testAnnotation and sharedEnvironmentAnnotation");
            if (testAnnotation == null && sharedEnvironmentAnnotation == null) {
                this.logger.debug((Object)"Test annotation is null and it's not a shared environment. Throwing TestRunException...");
                throw new TestRunException("Class " + testBundleName + "/" + testClassName + " is not annotated with either the dev.galasa @Test or @SharedEnvironment annotations");
            }
            if (testAnnotation != null && sharedEnvironmentAnnotation != null) {
                this.logger.debug((Object)"Test annotation is non-null and shared environment annotation is non-null. Throwing TestRunException...");
                throw new TestRunException("Class " + testBundleName + "/" + testClassName + " is annotated with both the dev.galasa @Test and @SharedEnvironment annotations");
            }
            if (testAnnotation != null) {
                this.logger.info((Object)("Run test: " + testBundleName + "/" + testClassName));
                this.detectedRunType = RunType.TEST;
            } else {
                this.logger.info((Object)("Shared Environment class: " + testBundleName + "/" + testClassName));
            }
            if (sharedEnvironmentAnnotation != null) {
                try {
                    SharedEnvironmentRunType seType = framework.getSharedEnvironmentRunType();
                    if (seType != null) {
                        switch (seType) {
                            case BUILD: {
                                this.detectedRunType = RunType.SHARED_ENVIRONMENT_BUILD;
                                break;
                            }
                            case DISCARD: {
                                this.detectedRunType = RunType.SHARED_ENVIRONMENT_DISCARD;
                                break;
                            }
                            default: {
                                String msg = "Unknown Shared Environment phase, '" + seType + "', needs to be BUILD or DISCARD";
                                this.logger.error((Object)msg);
                                throw new TestRunException(msg);
                            }
                        }
                        break block13;
                    }
                    String msg = "Unknown Shared Environment phase, needs to be BUILD or DISCARD";
                    this.logger.error((Object)msg);
                    throw new TestRunException(msg);
                }
                catch (TestRunException e) {
                    String msg = "TestRunException caught. " + e.getMessage() + " Re-throwing.";
                    this.logger.error((Object)msg);
                    throw e;
                }
                catch (Exception e) {
                    String msg = "Exception caught. " + e.getMessage() + " Re-throwing.";
                    this.logger.error((Object)msg);
                    throw new TestRunException("Unable to determine the phase of the shared environment", e);
                }
            }
        }
    }

    public RunType getDetectedRunType() {
        return this.detectedRunType;
    }

    public int getSharedEnvironmentExpireAfterHours() {
        return this.expireAfterHours;
    }
}

