/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.internal.runner;

import dev.galasa.framework.FileSystem;
import dev.galasa.framework.FrameworkInitialisation;
import dev.galasa.framework.IAnnotationExtractor;
import dev.galasa.framework.IBundleManager;
import dev.galasa.framework.IFileSystem;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.ITestRunnerDataProvider;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.TestRunManagers;
import dev.galasa.framework.internal.runner.BundleManager;
import dev.galasa.framework.internal.runner.ITestRunnerEventsProducer;
import dev.galasa.framework.internal.runner.RealAnnotationExtractor;
import dev.galasa.framework.internal.runner.TestRunnerEventsProducer;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IResultArchiveStore;
import dev.galasa.framework.spi.IRun;
import dev.galasa.framework.spi.IShuttableFramework;
import dev.galasa.framework.spi.language.GalasaTest;
import java.util.Properties;

public class TestRunnerDataProvider
implements ITestRunnerDataProvider {
    private IConfigurationPropertyStoreService cps;
    private IDynamicStatusStoreService dss;
    private IResultArchiveStore ras;
    private IRun run;
    private IShuttableFramework framework;
    private Properties overrideProperties;
    private IFileSystem fileSystem;
    private ITestRunnerEventsProducer eventsProducer;

    public TestRunnerDataProvider(Properties bootstrapProperties, Properties overrideProperties) throws TestRunException {
        FrameworkInitialisation frameworkInitialisation = null;
        try {
            boolean isThisATestRun = true;
            frameworkInitialisation = new FrameworkInitialisation(bootstrapProperties, overrideProperties, isThisATestRun);
            this.framework = frameworkInitialisation.getShutableFramework();
            this.cps = this.framework.getConfigurationPropertyService("framework");
            this.dss = this.framework.getDynamicStatusStoreService("framework");
        }
        catch (Exception e) {
            throw new TestRunException("Unable to initialise the Framework Services", e);
        }
        this.run = this.framework.getTestRun();
        this.ras = this.framework.getResultArchiveStore();
        this.fileSystem = new FileSystem();
        this.eventsProducer = new TestRunnerEventsProducer(this.framework.getEventsService(), this.cps);
        this.overrideProperties = overrideProperties;
    }

    @Override
    public IRun getRun() {
        return this.run;
    }

    @Override
    public IConfigurationPropertyStoreService getCPS() {
        return this.cps;
    }

    @Override
    public IDynamicStatusStoreService getDSS() {
        return this.dss;
    }

    @Override
    public IResultArchiveStore getRAS() {
        return this.ras;
    }

    @Override
    public IShuttableFramework getFramework() {
        return this.framework;
    }

    @Override
    public IBundleManager getBundleManager() {
        return new BundleManager();
    }

    @Override
    public IAnnotationExtractor getAnnotationExtractor() {
        return new RealAnnotationExtractor();
    }

    @Override
    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    @Override
    public ITestRunManagers createTestRunManagers(GalasaTest galasaTest) throws TestRunException {
        TestRunManagers managers;
        try {
            managers = new TestRunManagers(this.framework, galasaTest);
        }
        catch (FrameworkException e) {
            String msg = "FrameworkException Exception caught. " + e.getMessage();
            throw new TestRunException(msg, e);
        }
        return managers;
    }

    @Override
    public IFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public ITestRunnerEventsProducer getEventsProducer() {
        return this.eventsProducer;
    }
}

