/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi;

import dev.galasa.ManagerException;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.IGherkinExecutable;
import dev.galasa.framework.spi.IGherkinManager;
import dev.galasa.framework.spi.IStatementOwner;
import dev.galasa.framework.spi.language.gherkin.ExecutionMethod;
import dev.galasa.framework.spi.language.gherkin.GherkinTest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;

public abstract class AbstractGherkinManager
extends AbstractManager
implements IGherkinManager {
    public Boolean registerStatements(@NotNull GherkinTest test, @NotNull IStatementOwner[] owners) throws ManagerException {
        Boolean required = false;
        Object[] methodParams = new Class[]{IGherkinExecutable.class, Map.class};
        try {
            for (IGherkinExecutable executable : test.getAllExecutables()) {
                for (IStatementOwner owner : owners) {
                    for (Method method : owner.getClass().getDeclaredMethods()) {
                        Pattern annotationRegex;
                        Matcher regexMatcher;
                        ExecutionMethod executeAnno;
                        if (!Arrays.equals(method.getParameterTypes(), methodParams) || (executeAnno = method.getAnnotation(ExecutionMethod.class)) == null || !executeAnno.keyword().equals((Object)executable.getKeyword()) || !(regexMatcher = (annotationRegex = Pattern.compile(executeAnno.regex())).matcher(executable.getValue())).matches()) continue;
                        ArrayList<String> groups = new ArrayList<String>();
                        for (int i = 1; i <= regexMatcher.groupCount(); ++i) {
                            groups.add(regexMatcher.group(i));
                        }
                        executable.setRegexGroups(groups);
                        executable.registerManager(this);
                        executable.registerExecutionMethod(method, owner);
                        required = true;
                    }
                }
            }
            return required;
        }
        catch (TestRunException e) {
            throw new ManagerException("Issue registering statements", (Throwable)e);
        }
    }
}

