/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi;

import dev.galasa.framework.spi.DssAdd;
import dev.galasa.framework.spi.DssDelete;
import dev.galasa.framework.spi.DssDeletePrefix;
import dev.galasa.framework.spi.DssSwap;
import dev.galasa.framework.spi.DssUpdate;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreMatchException;
import dev.galasa.framework.spi.FrameworkPropertyFileException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IFrameworkPropertyFileWatcher;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FrameworkPropertyFile
implements FileAlterationListener {
    private Properties currentProperties = new Properties();
    private HashMap<UUID, Watch> watches = new HashMap();
    private URI file;
    private File propertyFile;
    private String parent;
    private FileAlterationObserver observer;
    private FileAlterationMonitor monitor;
    private static Log fpfLog = LogFactory.getLog(FrameworkPropertyFile.class);

    public FrameworkPropertyFile(URI file) throws FrameworkPropertyFileException {
        this.file = file;
        this.propertyFile = new File(file);
        this.parent = this.propertyFile.getParent();
        this.load();
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)this.propertyFile.getName());
        try {
            this.observer = new FileAlterationObserver(FileUtils.getFile((String[])new String[]{this.parent}), (FileFilter)filter);
            this.observer.addListener((FileAlterationListener)this);
            this.observer.initialize();
        }
        catch (Exception e) {
            throw new FrameworkPropertyFileException("Problem starting observer", e);
        }
    }

    public synchronized String get(String key) {
        this.observer.checkAndNotify();
        return this.currentProperties.getProperty(key);
    }

    public synchronized Map<String, String> getPrefix(String keyPrefix) {
        HashMap<String, String> values = new HashMap<String, String>();
        this.observer.checkAndNotify();
        for (Object k : this.currentProperties.keySet()) {
            String key = (String)k;
            if (!key.startsWith(keyPrefix)) continue;
            values.put(key, this.currentProperties.getProperty(key));
        }
        return values;
    }

    public synchronized List<String> getNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        this.observer.checkAndNotify();
        for (Object k : this.currentProperties.keySet()) {
            String name = ((String)k).substring(0, ((String)k).indexOf("."));
            if (namespaces.contains(name)) continue;
            namespaces.add(name);
        }
        return namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(String key) throws FrameworkPropertyFileException {
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                this.currentProperties.remove(key);
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (IOException e) {
                fpfLog.error((Object)("Unable to delete the key: " + key), (Throwable)e);
                throw new FrameworkPropertyFileException("Unable to delete key: " + key, e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(Set<String> keys) throws FrameworkPropertyFileException {
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                for (String key : keys) {
                    this.currentProperties.remove(key);
                }
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (IOException e) {
                fpfLog.error((Object)"Unable to delete keys", (Throwable)e);
                throw new FrameworkPropertyFileException("Unable to delete keys.", e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deletePrefix(String prefix) throws FrameworkPropertyFileException {
        HashSet<String> deleteKeys = new HashSet<String>();
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                for (Object k : this.currentProperties.keySet()) {
                    String key = (String)k;
                    if (!key.startsWith(prefix)) continue;
                    deleteKeys.add(key);
                }
                Properties oldProperties = (Properties)this.currentProperties.clone();
                for (String key : deleteKeys) {
                    this.currentProperties.remove(key);
                }
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (IOException e) {
                fpfLog.error((Object)"Failed to update file with DSS actions", (Throwable)e);
                throw new FrameworkPropertyFileException("Unable to delete key prefix: " + prefix, e);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void performActions(IDssAction ... actions) throws DynamicStatusStoreException, DynamicStatusStoreMatchException {
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                for (IDssAction action : actions) {
                    if (action instanceof DssAdd) {
                        this.performActionsAdd((DssAdd)action);
                        continue;
                    }
                    if (action instanceof DssDelete) {
                        this.performActionsDelete((DssDelete)action);
                        continue;
                    }
                    if (action instanceof DssDeletePrefix) {
                        this.performActionsDeletePrefix((DssDeletePrefix)action);
                        continue;
                    }
                    if (action instanceof DssUpdate) {
                        this.performActionsUpdate((DssUpdate)action);
                        continue;
                    }
                    if (action instanceof DssSwap) {
                        this.performActionsSwap((DssSwap)action);
                        continue;
                    }
                    throw new DynamicStatusStoreException("Unrecognised DSS Action - " + action.getClass().getName());
                }
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (IOException e) {
                fpfLog.error((Object)"Failed to update file with DSS actions", (Throwable)e);
                throw new DynamicStatusStoreException("Failed to update file with DSS actions", (Throwable)e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void performActionsAdd(DssAdd dssAdd) throws DynamicStatusStoreMatchException {
        String key = dssAdd.getKey();
        String value = dssAdd.getValue();
        String currentValue = this.currentProperties.getProperty(key);
        if (currentValue != null) {
            throw new DynamicStatusStoreMatchException("Attempt to add new property '" + key + "' but it already exists");
        }
        this.currentProperties.put(key, value);
    }

    private void performActionsDelete(DssDelete dssDelete) throws DynamicStatusStoreMatchException {
        String currentValue;
        String key = dssDelete.getKey();
        String oldValue = dssDelete.getOldValue();
        if (oldValue != null && !oldValue.equals(currentValue = this.currentProperties.getProperty(key))) {
            throw new DynamicStatusStoreMatchException("Attempt to delete property '" + key + "', but current value '" + currentValue + "' does not match required value '" + oldValue + "'");
        }
        this.currentProperties.remove(key);
    }

    private void performActionsDeletePrefix(DssDeletePrefix dssDeletePrefix) {
        ArrayList<String> toBeDeleted = new ArrayList<String>();
        for (Object k : this.currentProperties.keySet()) {
            String key = (String)k;
            if (!key.startsWith(dssDeletePrefix.getPrefix())) continue;
            toBeDeleted.add(key);
        }
        for (String key : toBeDeleted) {
            this.currentProperties.remove(key);
        }
    }

    private void performActionsUpdate(DssUpdate dssUpdate) {
        String key = dssUpdate.getKey();
        String value = dssUpdate.getValue();
        this.currentProperties.put(key, value);
    }

    private void performActionsSwap(DssSwap dssSwap) throws DynamicStatusStoreMatchException {
        String key = dssSwap.getKey();
        String newValue = dssSwap.getNewValue();
        String oldValue = dssSwap.getOldValue();
        String currentValue = this.currentProperties.getProperty(key);
        if (oldValue == null ? currentValue != null : !oldValue.equals(currentValue)) {
            throw new DynamicStatusStoreMatchException("Attempt to swap property '" + key + "', but current value '" + currentValue + "' does not match required value '" + oldValue + "'");
        }
        this.currentProperties.put(key, newValue);
    }

    public synchronized void write(FileChannel fileChannel, Properties newProperties) throws IOException {
        fileChannel.truncate(0L);
        OutputStream out = Channels.newOutputStream(fileChannel);
        newProperties.store(out, null);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(String key, String value) throws FrameworkPropertyFileException {
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                this.currentProperties.put(key, value);
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (IOException e) {
                fpfLog.error((Object)("Unable to set key value pair: " + key + ":" + value), (Throwable)e);
                throw new FrameworkPropertyFileException("Failed Setting value: " + key + "=" + value, e);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(Map<String, String> values) throws FrameworkPropertyFileException, IOException {
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                this.currentProperties.putAll(values);
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (IOException e) {
                fpfLog.error((Object)"Unable to set values", (Throwable)e);
                throw new FrameworkPropertyFileException("Unable to set values", e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized UUID watch(IFrameworkPropertyFileWatcher watcher, String key) throws FrameworkPropertyFileException {
        if (this.monitor == null) {
            this.monitor = new FileAlterationMonitor(50L, new FileAlterationObserver[]{this.observer});
            try {
                this.monitor.start();
            }
            catch (Exception e) {
                throw new FrameworkPropertyFileException("Unable to start file monitor", e);
            }
        }
        UUID watchID = UUID.randomUUID();
        this.watches.put(watchID, new Watch(watcher, key, false));
        return watchID;
    }

    public synchronized void unwatch(UUID watchId) throws FrameworkPropertyFileException {
        this.watches.remove(watchId);
        if (this.watches.isEmpty() && this.monitor != null) {
            this.monitor.removeObserver(this.observer);
            try {
                this.monitor.stop();
            }
            catch (Exception e) {
                throw new FrameworkPropertyFileException("Problems encountered during the stop of the monitor", e);
            }
            this.monitor = null;
        }
    }

    public synchronized UUID watchPrefix(IFrameworkPropertyFileWatcher watcher, String keyPrefix) throws FrameworkPropertyFileException {
        if (this.monitor == null) {
            this.monitor = new FileAlterationMonitor(50L, new FileAlterationObserver[]{this.observer});
            try {
                this.monitor.start();
            }
            catch (Exception e) {
                throw new FrameworkPropertyFileException("Unable to start file monitor for prefixs", e);
            }
        }
        UUID watchID = UUID.randomUUID();
        this.watches.put(watchID, new Watch(watcher, keyPrefix, true));
        return watchID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean setAtomic(String key, String oldValue, String newValue) throws FrameworkPropertyFileException {
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                if (oldValue == null && oldProperties.get(key) == null) {
                    this.currentProperties.put(key, newValue);
                } else {
                    if (oldValue == null) {
                        boolean bl = false;
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return bl;
                    }
                    if (!this.currentProperties.replace(key, oldValue, newValue)) {
                        boolean bl = false;
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return bl;
                    }
                }
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
                boolean bl = true;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return bl;
            }
            catch (IOException e) {
                fpfLog.error((Object)"Failed to set Atomically", (Throwable)e);
                throw new FrameworkPropertyFileException("Failed to set atomically", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean setAtomic(String key, String oldValue, String newValue, Map<String, String> otherValues) throws FrameworkPropertyFileException {
        if (this.observer != null) {
            this.observer.checkAndNotify();
        }
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getWriteChannel(false);){
                Properties oldProperties = (Properties)this.currentProperties.clone();
                if (oldValue == null && oldProperties.get(key) == null) {
                    this.currentProperties.put(key, newValue);
                } else {
                    if (oldValue == null) {
                        boolean bl = false;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return bl;
                    }
                    if (!this.currentProperties.replace(key, oldValue, newValue)) {
                        boolean bl = false;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return bl;
                    }
                }
                this.currentProperties.putAll(otherValues);
                this.write(fileChannel, this.currentProperties);
                this.fileModified(this.currentProperties, oldProperties);
                boolean bl = true;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return bl;
            }
            catch (IOException e) {
                fpfLog.error((Object)"Failed to set Atomically", (Throwable)e);
                throw new FrameworkPropertyFileException("Failed to set atomically", e);
            }
        }
    }

    public synchronized void destroy() throws FrameworkPropertyFileException {
        this.currentProperties = null;
        this.observer = null;
        try {
            if (this.monitor != null) {
                this.monitor.stop();
            }
        }
        catch (Exception e) {
            throw new FrameworkPropertyFileException("Unable to stop the monitor.", e);
        }
    }

    private synchronized void fileModified(Properties newProperties, Properties oldProperties) {
        for (Watch watch : this.watches.values()) {
            for (Object oNewKey : newProperties.keySet()) {
                String newKey = (String)oNewKey;
                String newValue = newProperties.getProperty(newKey);
                if (!watch.matchKey(newKey)) continue;
                String oldValue = oldProperties.getProperty(newKey);
                if (oldValue == null) {
                    watch.watcher.propertyModified(newKey, IFrameworkPropertyFileWatcher.Event.NEW, oldValue, newValue);
                    continue;
                }
                if (oldValue.equals(newValue)) continue;
                watch.watcher.propertyModified(newKey, IFrameworkPropertyFileWatcher.Event.MODIFIED, oldValue, newValue);
            }
            for (Object oOldKey : oldProperties.keySet()) {
                String newValue;
                String oldKey = (String)oOldKey;
                String oldValue = oldProperties.getProperty(oldKey);
                if (!watch.matchKey(oldKey) || (newValue = newProperties.getProperty(oldKey)) != null) continue;
                watch.watcher.propertyModified(oldKey, IFrameworkPropertyFileWatcher.Event.DELETE, oldValue, newValue);
            }
        }
    }

    private synchronized FileChannel getReadChannel(boolean shared) throws IOException {
        Path path = Paths.get(this.file);
        FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);
        try {
            fileChannel.lock(0L, Long.MAX_VALUE, shared);
            return fileChannel;
        }
        catch (IOException e) {
            fileChannel.close();
            throw e;
        }
    }

    private synchronized FileChannel getWriteChannel(boolean shared) throws IOException {
        Path path = Paths.get(this.file);
        FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE);
        try {
            fileChannel.lock(0L, Long.MAX_VALUE, shared);
            return fileChannel;
        }
        catch (IOException e) {
            fileChannel.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws FrameworkPropertyFileException {
        Properties newProperties = new Properties();
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try (FileChannel fileChannel = this.getReadChannel(true);){
                InputStream in = Channels.newInputStream(fileChannel);
                newProperties.load(in);
                in.close();
            }
            catch (IOException e) {
                fpfLog.error((Object)"Unable to Load Property from file", (Throwable)e);
                throw new FrameworkPropertyFileException("Unable to Load Property from file: " + this.propertyFile.toString(), e);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.currentProperties = newProperties;
            return;
        }
    }

    public void onStart(FileAlterationObserver observer) {
    }

    public void onStop(FileAlterationObserver observer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onFileChange(File file) {
        Class<FrameworkPropertyFile> clazz = FrameworkPropertyFile.class;
        synchronized (FrameworkPropertyFile.class) {
            try {
                Properties oldProperties = (Properties)this.currentProperties.clone();
                this.load();
                this.fileModified(this.currentProperties, oldProperties);
            }
            catch (FrameworkPropertyFileException e) {
                fpfLog.error((Object)"Error encounted loading file changes", (Throwable)e);
            }
            return;
        }
    }

    public void onFileCreate(File file) {
    }

    public void onFileDelete(File file) {
    }

    public void onDirectoryCreate(File file) {
    }

    public void onDirectoryChange(File file) {
    }

    public void onDirectoryDelete(File file) {
    }

    public synchronized void shutdown() throws FrameworkPropertyFileException {
        if (this.monitor != null) {
            try {
                this.monitor.removeObserver(this.observer);
                this.monitor.stop();
                this.monitor = null;
            }
            catch (Throwable t) {
                throw new FrameworkPropertyFileException("Problem stopping the file monitor", t);
            }
        }
        this.watches.clear();
    }

    private class Watch {
        private final IFrameworkPropertyFileWatcher watcher;
        private final String key;
        private final boolean prefix;

        private Watch(IFrameworkPropertyFileWatcher watcher, String key, boolean prefix) {
            this.watcher = watcher;
            this.key = key;
            this.prefix = prefix;
        }

        public boolean matchKey(String newKey) {
            if (this.prefix) {
                return newKey.startsWith(this.key);
            }
            return newKey.equals(this.key);
        }
    }
}

