/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.cps;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CpsProperties {
    protected static int getIntWithDefault(@NotNull IConfigurationPropertyStoreService cps, @NotNull int defaultValue, @NotNull String prefix, @NotNull String suffix, String ... infixes) {
        try {
            String sValue = cps.getProperty(prefix, suffix, infixes);
            if (sValue == null || sValue.trim().isEmpty()) {
                return defaultValue;
            }
            return Integer.parseInt(sValue.trim());
        }
        catch (Exception e) {
            Log logger = LogFactory.getLog((String)CpsProperties.class.getName());
            logger.warn((Object)("Invalid property, using default " + defaultValue), (Throwable)e);
            return defaultValue;
        }
    }

    protected static String getStringNulled(@NotNull IConfigurationPropertyStoreService cps, @NotNull String prefix, @NotNull String suffix, String ... infixes) throws ConfigurationPropertyStoreException {
        String sValue = cps.getProperty(prefix, suffix, infixes);
        if (sValue != null && sValue.trim().isEmpty()) {
            return null;
        }
        return sValue;
    }

    @NotNull
    protected static String getStringWithDefault(@NotNull IConfigurationPropertyStoreService cps, @NotNull String defaultValue, @NotNull String prefix, @NotNull String suffix, String ... infixes) {
        try {
            String sValue = cps.getProperty(prefix, suffix, infixes);
            if (sValue == null || sValue.trim().isEmpty()) {
                return defaultValue;
            }
            return sValue;
        }
        catch (Exception e) {
            Log logger = LogFactory.getLog((String)CpsProperties.class.getName());
            logger.warn((Object)("Invalid property, using default " + defaultValue), (Throwable)e);
            return defaultValue;
        }
    }

    @NotNull
    protected static List<String> getStringListWithDefault(@NotNull IConfigurationPropertyStoreService cps, @NotNull String defaultValues, @NotNull String prefix, @NotNull String suffix, String ... infixes) {
        try {
            String sValue = cps.getProperty(prefix, suffix, infixes);
            if (sValue == null || sValue.trim().isEmpty()) {
                return CpsProperties.splitToList(defaultValues);
            }
            List<String> result = CpsProperties.splitToList(sValue);
            if (result.isEmpty()) {
                return CpsProperties.splitToList(defaultValues);
            }
            return result;
        }
        catch (Exception e) {
            Log logger = LogFactory.getLog((String)CpsProperties.class.getName());
            logger.warn((Object)("Invalid property, using default " + defaultValues.toString()), (Throwable)e);
            return CpsProperties.splitToList(defaultValues);
        }
    }

    @NotNull
    protected static List<String> getStringList(@NotNull IConfigurationPropertyStoreService cps, @NotNull String prefix, @NotNull String suffix, String ... infixes) throws ConfigurationPropertyStoreException {
        String sValue = cps.getProperty(prefix, suffix, infixes);
        if (sValue == null || sValue.trim().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> result = CpsProperties.splitToList(sValue);
        return result;
    }

    @NotNull
    private static List<String> splitToList(@NotNull String values) {
        String[] split;
        ArrayList<String> defaults = new ArrayList<String>();
        for (String v : split = values.split(",")) {
            if (v == null || v.trim().isEmpty()) continue;
            defaults.add(v.trim());
        }
        return defaults;
    }
}

