/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.ICredentials;
import dev.galasa.framework.spi.creds.Credentials;
import dev.galasa.framework.spi.creds.CredentialsException;
import java.time.Instant;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractCredentials
extends Credentials
implements ICredentials {
    protected static final String CREDS_PROPERTY_PREFIX = "secure.credentials.";
    private String description;
    private String lastUpdatedByUser;
    private Instant lastUpdatedTime;

    public AbstractCredentials(SecretKeySpec key) throws CredentialsException {
        super(key);
    }

    public AbstractCredentials() {
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLastUpdatedByUser(String username) {
        this.lastUpdatedByUser = username;
    }

    public void setLastUpdatedTime(Instant time) {
        this.lastUpdatedTime = time;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLastUpdatedByUser() {
        return this.lastUpdatedByUser;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Properties getMetadataProperties(String credentialsId) {
        Properties properties = new Properties();
        if (this.description != null) {
            properties.put(CREDS_PROPERTY_PREFIX + credentialsId + ".description", this.description);
        }
        if (this.lastUpdatedTime != null) {
            properties.put(CREDS_PROPERTY_PREFIX + credentialsId + ".lastUpdated.time", this.lastUpdatedTime.toString());
        }
        if (this.lastUpdatedByUser != null) {
            properties.put(CREDS_PROPERTY_PREFIX + credentialsId + ".lastUpdated.user", this.lastUpdatedByUser);
        }
        return properties;
    }
}

