/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.ICredentialsToken;
import dev.galasa.framework.spi.creds.AbstractCredentials;
import dev.galasa.framework.spi.creds.CredentialsException;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class CredentialsToken
extends AbstractCredentials
implements ICredentialsToken {
    private final byte[] token;

    public CredentialsToken(String plainTextToken) {
        this.token = plainTextToken.getBytes();
    }

    public CredentialsToken(SecretKeySpec key, String stoken) throws CredentialsException {
        super(key);
        String decryptedToken = this.decryptToString(stoken);
        this.token = decryptedToken == null ? this.decode(stoken) : decryptedToken.getBytes();
    }

    public byte[] getToken() {
        return this.token;
    }

    public Properties toProperties(String credentialsId) {
        Properties credsProperties = new Properties();
        credsProperties.setProperty("secure.credentials." + credentialsId + ".token", new String(this.token));
        return credsProperties;
    }
}

