/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.ICredentialsUsername;
import dev.galasa.framework.spi.creds.AbstractCredentials;
import dev.galasa.framework.spi.creds.CredentialsException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class CredentialsUsername
extends AbstractCredentials
implements ICredentialsUsername {
    private String username;

    public CredentialsUsername(String plainTextUsername) {
        this.username = plainTextUsername;
    }

    public CredentialsUsername(SecretKeySpec key, String username) throws CredentialsException {
        super(key);
        this.username = this.decryptToString(username);
        if (this.username == null) {
            this.username = new String(this.decode(username), StandardCharsets.UTF_8);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Properties toProperties(String credentialsId) {
        Properties credsProperties = new Properties();
        credsProperties.setProperty("secure.credentials." + credentialsId + ".username", this.username);
        return credsProperties;
    }
}

