/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.framework.spi.creds.AbstractCredentials;
import dev.galasa.framework.spi.creds.CredentialsException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class CredentialsUsernamePassword
extends AbstractCredentials
implements ICredentialsUsernamePassword {
    private String username;
    private String password;

    public CredentialsUsernamePassword(String plainTextUsername, String plainTextPassword) {
        this.username = plainTextUsername;
        this.password = plainTextPassword;
    }

    public CredentialsUsernamePassword(SecretKeySpec key, String username, String password) throws CredentialsException {
        super(key);
        this.username = this.decryptToString(username);
        this.password = this.decryptToString(password);
        if (this.username == null) {
            this.username = new String(this.decode(username), StandardCharsets.UTF_8);
        }
        if (this.password == null) {
            this.password = new String(this.decode(password), StandardCharsets.UTF_8);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties toProperties(String credentialsId) {
        Properties credsProperties = new Properties();
        credsProperties.setProperty("secure.credentials." + credentialsId + ".username", this.username);
        credsProperties.setProperty("secure.credentials." + credentialsId + ".password", this.password);
        return credsProperties;
    }
}

