/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.ICredentialsUsernameToken;
import dev.galasa.framework.spi.creds.AbstractCredentials;
import dev.galasa.framework.spi.creds.CredentialsException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class CredentialsUsernameToken
extends AbstractCredentials
implements ICredentialsUsernameToken {
    private String username;
    private byte[] token;

    public CredentialsUsernameToken(String plainTextUsername, String encryptedToken) {
        this.username = plainTextUsername;
        this.token = encryptedToken.getBytes();
    }

    public CredentialsUsernameToken(SecretKeySpec key, String username, String token) throws CredentialsException {
        super(key);
        String decryptedToken;
        this.username = this.decryptToString(username);
        if (this.username == null) {
            this.username = new String(this.decode(username), StandardCharsets.UTF_8);
        }
        this.token = (decryptedToken = this.decryptToString(token)) == null ? this.decode(token) : decryptedToken.getBytes();
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getToken() {
        return this.token;
    }

    public Properties toProperties(String credentialsId) {
        Properties credsProperties = new Properties();
        credsProperties.setProperty("secure.credentials." + credentialsId + ".username", this.username);
        credsProperties.setProperty("secure.credentials." + credentialsId + ".token", new String(this.token));
        return credsProperties;
    }
}

