/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.framework.IFileSystem;
import dev.galasa.framework.spi.Environment;
import dev.galasa.framework.spi.creds.CredentialsException;
import java.nio.file.Paths;
import java.util.List;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class EncryptionKeys {
    private String encryptionKey;
    private List<String> fallbackDecryptionKeys;

    public EncryptionKeys() {
    }

    public EncryptionKeys(IFileSystem fileSystem, Environment environment) throws CredentialsException {
        EncryptionKeys parsedEncryptionKeys = this.parseEncryptionKeysFile(fileSystem, environment);
        this.encryptionKey = parsedEncryptionKeys.getEncryptionKey();
        this.fallbackDecryptionKeys = parsedEncryptionKeys.getFallbackDecryptionKeys();
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public List<String> getFallbackDecryptionKeys() {
        return this.fallbackDecryptionKeys;
    }

    public void setFallbackDecryptionKeys(List<String> fallbackDecryptionKeys) {
        this.fallbackDecryptionKeys = fallbackDecryptionKeys;
    }

    private EncryptionKeys parseEncryptionKeysFile(IFileSystem fileSystem, Environment environment) throws CredentialsException {
        EncryptionKeys encryptionKeys = this;
        String encryptionKeysLocation = environment.getenv("GALASA_ENCRYPTION_KEYS_PATH");
        if (encryptionKeysLocation != null) {
            try {
                String encryptionKeysYamlStr = fileSystem.readString(Paths.get(encryptionKeysLocation, new String[0]));
                if (encryptionKeysYamlStr != null && !encryptionKeysYamlStr.isBlank()) {
                    Yaml yamlParser = new Yaml((BaseConstructor)new Constructor(EncryptionKeys.class, new LoaderOptions()));
                    encryptionKeys = (EncryptionKeys)yamlParser.load(encryptionKeysYamlStr);
                }
            }
            catch (Exception e) {
                throw new CredentialsException("Failed to read encryption keys file", (Throwable)e);
            }
        }
        return encryptionKeys;
    }
}

