/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.creds;

import dev.galasa.framework.FileSystem;
import dev.galasa.framework.IFileSystem;
import dev.galasa.framework.spi.Environment;
import dev.galasa.framework.spi.SystemEnvironment;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.framework.spi.creds.EncryptionKeys;
import dev.galasa.framework.spi.creds.IEncryptionService;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FrameworkEncryptionService
implements IEncryptionService {
    public static final String ENCRYPTION_KEYS_PATH_ENV = "GALASA_ENCRYPTION_KEYS_PATH";
    private static final String KEY_ALGORITHM = "AES";
    private static final String ENCRYPTION_ALGORITHM = "AES/GCM/NoPadding";
    private static final int GCM_AUTH_TAG_LENGTH_BITS = 128;
    private static final int GCM_IV_BYTES_LENGTH = 12;
    private SecretKeySpec encryptionKey;
    private List<SecretKeySpec> decryptionKeys = new ArrayList<SecretKeySpec>();
    private SecureRandom secureRandom;

    public FrameworkEncryptionService(SecretKeySpec encryptionKey) throws CredentialsException {
        this(encryptionKey, new FileSystem(), new SystemEnvironment(), new SecureRandom());
    }

    public FrameworkEncryptionService(SecretKeySpec encryptionKey, IFileSystem fileSystem, Environment environment) throws CredentialsException {
        this(encryptionKey, fileSystem, environment, new SecureRandom());
    }

    public FrameworkEncryptionService(SecretKeySpec encryptionKey, IFileSystem fileSystem, Environment environment, SecureRandom secureRandom) throws CredentialsException {
        this.encryptionKey = encryptionKey;
        this.secureRandom = secureRandom;
        if (encryptionKey == null) {
            EncryptionKeys encryptionKeys = new EncryptionKeys(fileSystem, environment);
            String parsedEncryptionKey = encryptionKeys.getEncryptionKey();
            List<String> parsedFallbackKeys = encryptionKeys.getFallbackDecryptionKeys();
            if (parsedEncryptionKey != null && parsedFallbackKeys != null) {
                this.encryptionKey = this.loadPrimaryEncryptionKey(parsedEncryptionKey);
                this.decryptionKeys = this.loadDecryptionKeys(this.encryptionKey, parsedFallbackKeys);
            }
        } else {
            this.decryptionKeys = new ArrayList<SecretKeySpec>();
            this.decryptionKeys.add(encryptionKey);
        }
    }

    private SecretKeySpec loadPrimaryEncryptionKey(String encodedKeyStr) throws CredentialsException {
        byte[] decodedPrimaryKeyBytes = Base64.getDecoder().decode(encodedKeyStr);
        return new SecretKeySpec(decodedPrimaryKeyBytes, KEY_ALGORITHM);
    }

    private List<SecretKeySpec> loadDecryptionKeys(SecretKeySpec primaryEncryptionKey, List<String> encodedFallbackKeys) throws CredentialsException {
        ArrayList<SecretKeySpec> decryptionKeys = new ArrayList<SecretKeySpec>();
        decryptionKeys.add(primaryEncryptionKey);
        for (String fallbackKey : encodedFallbackKeys) {
            byte[] decodedFallbackKeyBytes = Base64.getDecoder().decode(fallbackKey);
            SecretKeySpec key = new SecretKeySpec(decodedFallbackKeyBytes, KEY_ALGORITHM);
            decryptionKeys.add(key);
        }
        return decryptionKeys;
    }

    @Override
    public String encrypt(String plainText) throws CredentialsException {
        byte[] encryptedIvAndText;
        if (this.encryptionKey == null) {
            throw new CredentialsException("Unable to encrypt the provided data. No encryption key has been set");
        }
        byte[] initVector = new byte[12];
        this.secureRandom.nextBytes(initVector);
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, initVector);
            cipher.init(1, (Key)this.encryptionKey, gcmParameterSpec);
            byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
            encryptedIvAndText = new byte[initVector.length + encryptedBytes.length];
            System.arraycopy(initVector, 0, encryptedIvAndText, 0, initVector.length);
            System.arraycopy(encryptedBytes, 0, encryptedIvAndText, initVector.length, encryptedBytes.length);
        }
        catch (Exception e) {
            throw new CredentialsException("Failed to encrypt the provided data", (Throwable)e);
        }
        return Base64.getEncoder().encodeToString(encryptedIvAndText);
    }

    @Override
    public String decrypt(String encryptedText) throws CredentialsException {
        String decryptedText = null;
        for (SecretKeySpec key : this.decryptionKeys) {
            try {
                decryptedText = this.decrypt(encryptedText, key);
            }
            catch (CredentialsException credentialsException) {}
        }
        return decryptedText;
    }

    private String decrypt(String encryptedText, SecretKeySpec decryptionKey) throws CredentialsException {
        String decryptedText = null;
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(encryptedText);
            byte[] initVector = new byte[12];
            System.arraycopy(decodedBytes, 0, initVector, 0, initVector.length);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, initVector);
            cipher.init(2, (Key)decryptionKey, gcmParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(decodedBytes, initVector.length, decodedBytes.length - initVector.length);
            decryptedText = new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new CredentialsException("Failed to decrypt the provided data", (Throwable)e);
        }
        return decryptedText;
    }
}

