/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin;

import dev.galasa.ManagerException;
import dev.galasa.framework.ITestRunManagers;
import dev.galasa.framework.TestRunException;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IGherkinExecutable;
import dev.galasa.framework.spi.Result;
import dev.galasa.framework.spi.language.GalasaMethod;
import dev.galasa.framework.spi.language.gherkin.GherkinStatement;
import dev.galasa.framework.spi.language.gherkin.GherkinTest;
import dev.galasa.framework.spi.teststructure.TestGherkinMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GherkinMethod {
    private Log logger = LogFactory.getLog(GherkinMethod.class);
    private String name;
    private transient List<IGherkinExecutable> executables;
    private String testName;
    private Result result;
    private TestGherkinMethod testStructureMethod;

    public GherkinMethod(String name, String testName) {
        this.name = name;
        this.executables = new ArrayList<IGherkinExecutable>();
        this.testName = testName;
        this.testStructureMethod = new TestGherkinMethod();
        this.testStructureMethod.setMethodName(name);
    }

    public void addStep(String statement) throws TestRunException {
        this.executables.add(GherkinStatement.get(statement));
    }

    public String getName() {
        return this.name;
    }

    public List<IGherkinExecutable> getExecutables() {
        return this.executables;
    }

    public void invoke(ITestRunManagers managers, Map<String, Object> testVariables) throws TestRunException {
        try {
            managers.startOfTestMethod(new GalasaMethod(this));
            this.logger.info((Object)("Starting" + GherkinTest.LOG_START_LINE + GherkinTest.LOG_ASTERS + GherkinTest.LOG_START_LINE + "*** Start of test method " + this.testName + "#" + this.name + GherkinTest.LOG_START_LINE + GherkinTest.LOG_ASTERS));
            this.testStructureMethod.setStartTime(Instant.now());
            this.testStructureMethod.setStatus("started");
            for (IGherkinExecutable executable : this.executables) {
                try {
                    this.logger.info((Object)("Executing Statement: " + executable.getKeyword() + " " + executable.getValue()));
                    executable.execute(testVariables);
                }
                catch (ManagerException e) {
                    this.result = Result.failed(e);
                    break;
                }
            }
            if (this.result == null) {
                this.result = Result.passed();
            }
            this.testStructureMethod.setResult(this.result.getName());
            Result overrideResult = managers.endOfTestMethod(new GalasaMethod(this), this.result, this.result.getThrowable());
            if (overrideResult != null) {
                this.result = overrideResult;
            }
            if (this.result.getThrowable() != null) {
                Throwable t = this.result.getThrowable();
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    this.testStructureMethod.setException(sw.toString());
                }
                catch (Exception e) {
                    this.testStructureMethod.setException("Unable to report exception because of " + e.getMessage());
                }
            }
            if (this.result.isPassed()) {
                String resname = this.result.getName();
                this.logger.info((Object)("Ending" + GherkinTest.LOG_START_LINE + GherkinTest.LOG_ASTERS + GherkinTest.LOG_START_LINE + "*** " + resname + " - Test method " + this.testName + "#" + this.name + GherkinTest.LOG_START_LINE + GherkinTest.LOG_ASTERS));
            } else {
                Object exception = "";
                if (this.testStructureMethod.getException() != null) {
                    exception = "\n" + this.testStructureMethod.getException();
                }
                this.logger.info((Object)("Ending" + GherkinTest.LOG_START_LINE + GherkinTest.LOG_ASTERS + GherkinTest.LOG_START_LINE + "*** " + this.result.getName() + " - Test method " + this.testName + "#" + this.name + GherkinTest.LOG_START_LINE + GherkinTest.LOG_ASTERS + (String)exception));
            }
            this.testStructureMethod.setEndTime(Instant.now());
            this.testStructureMethod.setStatus("finished");
        }
        catch (FrameworkException e) {
            throw new TestRunException("There was a problem with the framework, please check stacktrace", e);
        }
    }

    public boolean fullStop() {
        return this.result.isFailed();
    }

    public Result getResult() {
        return this.result;
    }

    public TestGherkinMethod getStructure() {
        return this.testStructureMethod;
    }
}

