/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin.parser;

import dev.galasa.framework.spi.language.gherkin.parser.TokenType;
import java.util.ArrayList;
import java.util.List;

public class ParseToken {
    private TokenType type;
    private String text;
    private int lineNumber;
    List<ParseToken> children = new ArrayList<ParseToken>();

    public ParseToken(TokenType type, String text) {
        this(type, text, 0);
    }

    public ParseToken(TokenType type, String text, int lineNumber) {
        this.type = type;
        this.text = text;
        this.lineNumber = lineNumber;
    }

    public TokenType getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("{token:");
        buff.append(this.type.getReadableName());
        buff.append(", line:");
        buff.append(this.lineNumber);
        buff.append(", text:");
        buff.append(this.text);
        buff.append("}");
        return buff.toString();
    }

    public String getText() {
        return this.text;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<ParseToken> getChildren() {
        return this.children;
    }

    public boolean equals(Object obj) {
        boolean isSame = false;
        if (obj != null && ParseToken.class.isAssignableFrom(obj.getClass())) {
            ParseToken other = (ParseToken)obj;
            isSame = other.type.equals((Object)this.type) && other.text.equals(this.text) && other.lineNumber == this.lineNumber;
        }
        return isSame;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        for (ParseToken child : this.children) {
            result = 31 * result + child.hashCode();
        }
        result = 31 * result + this.lineNumber;
        return result;
    }

    public void addChildren(List<ParseToken> children) {
        this.children = children;
    }

    public void setLineNumber(int newLineNumber) {
        this.lineNumber = newLineNumber;
    }

    public void setText(String text) {
        this.text = text;
    }
}

