/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.language.gherkin.xform;

import dev.galasa.framework.TestRunException;
import dev.galasa.framework.spi.language.gherkin.GherkinFeature;
import dev.galasa.framework.spi.language.gherkin.GherkinMethod;
import dev.galasa.framework.spi.language.gherkin.GherkinVariables;
import dev.galasa.framework.spi.language.gherkin.parser.ParseToken;
import dev.galasa.framework.spi.language.gherkin.xform.ParseTreeNavigator;
import dev.galasa.framework.spi.language.gherkin.xform.ParseTreeVisitorBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParseTreeTransform
extends ParseTreeVisitorBase {
    private List<ParseToken> steps;
    private GherkinFeature feature;
    private GherkinVariables variables;

    public GherkinFeature getFeature() {
        return this.feature;
    }

    @Override
    public void visit(ParseToken token) throws TestRunException {
        ParseTreeNavigator navigator = new ParseTreeNavigator(this);
        navigator.visit(token);
    }

    @Override
    public void visitFeature(ParseToken token) throws TestRunException {
        GherkinFeature feature;
        this.feature = feature = new GherkinFeature();
        feature.setName(token.getText());
    }

    @Override
    public void visitScenario(ParseToken token) throws TestRunException {
        this.steps = new ArrayList<ParseToken>();
    }

    @Override
    public void postVisitScenario(ParseToken token) throws TestRunException {
        String scenarioName = token.getText();
        GherkinMethod scenario = new GherkinMethod(scenarioName, this.feature.getName());
        this.feature.getScenarios().add(scenario);
        for (ParseToken stepToken : this.steps) {
            scenario.addStep(stepToken.getText());
        }
        this.steps = null;
    }

    @Override
    public void visitScenarioOutline(ParseToken token) throws TestRunException {
        this.variables = new GherkinVariables();
        this.steps = new ArrayList<ParseToken>();
    }

    @Override
    public void postVisitScenarioOutline(ParseToken token) throws TestRunException {
        int instancesToProcess = this.variables.getNumberOfInstances();
        for (int instance = 0; instance < instancesToProcess; ++instance) {
            String instanceScenarioName = token.getText() + "-" + Integer.toString(instance);
            GherkinMethod scenario = new GherkinMethod(instanceScenarioName, this.feature.getName());
            for (ParseToken stepToken : this.steps) {
                String stepText = stepToken.getText();
                Map<String, Object> variableMapInstance = this.variables.getVariableInstance(instance);
                for (Map.Entry<String, Object> entry : variableMapInstance.entrySet()) {
                    String variableName = "<" + entry.getKey() + ">";
                    String variableValue = (String)entry.getValue();
                    stepText = stepText.replaceAll(variableName, variableValue);
                }
                scenario.addStep(stepText);
            }
            this.feature.getScenarios().add(scenario);
        }
        this.variables = null;
        this.steps = null;
    }

    @Override
    public void visitStep(ParseToken token) throws TestRunException {
        this.steps.add(token);
    }

    @Override
    public void visitDataTableHeader(ParseToken token) throws TestRunException {
        this.variables.processHeaderLine(token.getText());
    }

    @Override
    public void visitDataTableLineList(ParseToken token) throws TestRunException {
        if (token.getChildren().size() > 0) {
            this.variables.processDataLine(token.getText());
        }
    }
}

