/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.spi.ras;

import dev.galasa.framework.spi.ras.ResultArchiveStoreFileSystemProvider;
import dev.galasa.framework.spi.ras.ResultArchiveStorePath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ResultArchiveStoreFileSystem
extends FileSystem {
    private final ResultArchiveStoreFileSystemProvider fileSystemProvider;
    private boolean readOnly = false;

    public ResultArchiveStoreFileSystem(ResultArchiveStoreFileSystemProvider fileSystemProvider) {
        this.fileSystemProvider = fileSystemProvider;
    }

    @Override
    public ResultArchiveStoreFileSystemProvider provider() {
        return this.fileSystemProvider;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ArrayList<Path> roots = new ArrayList<Path>();
        roots.add(this.newPathObject("/"));
        return roots;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        ArrayList<FileStore> fileStores = new ArrayList<FileStore>();
        fileStores.add(this.fileSystemProvider.getActualFileStore());
        return fileStores;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        HashSet<String> set = new HashSet<String>();
        set.add("basic");
        set.add("ras");
        return set;
    }

    @Override
    public Path getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder();
        if (first != null) {
            sb.append(first);
        }
        for (String m : more) {
            if (m == null) continue;
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(m);
        }
        return this.newPathObject(sb.toString());
    }

    protected ResultArchiveStorePath newPathObject(String path) {
        return new ResultArchiveStorePath(this, path);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        String expr;
        int pos = syntaxAndInput.indexOf(58);
        if (pos <= 0 || pos >= syntaxAndInput.length() - 1) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        if ("glob".equals(syntax)) {
            expr = ResultArchiveStoreFileSystem.createRegexFromGlob(input);
        } else if ("regex".equals(syntax)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        final Pattern pattern = Pattern.compile(expr);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }

            public String toString() {
                return pattern.toString();
            }
        };
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return null;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("WatchService is unavailable on RAS File Systems");
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static String createRegexFromGlob(String glob) {
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }
}

